/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model.transform;

import java.util.ArrayList;
import java.util.List;

import com.nifty.cloud.sdk.multiloadbalancer.model.AvailabilityZones;
import com.nifty.cloud.sdk.multiloadbalancer.model.ElasticLoadBalancerDescriptions;
import com.nifty.cloud.sdk.multiloadbalancer.model.ElasticLoadBalancerDescriptionsMember;
import com.nifty.cloud.sdk.multiloadbalancer.model.ElasticLoadBalancerListenerDescriptions;
import com.nifty.cloud.sdk.multiloadbalancer.model.NetworkInterface;
import com.nifty.cloud.sdk.multiloadbalancer.model.VersionInformation;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

/**
 * ElasticLoadBalancerDescriptions変換クラス。<br />
 * このクラスはレスポンスXMLからElasticLoadBalancerDescriptionsクラスを生成します。
 */
public class ElasticLoadBalancerDescriptionsConverter implements Converter {

    private static final String ELEMENT_MEMBER = "member";
    private static final String ELEMENT_ELASTIC_LOAD_BALANCER_ID = "ElasticLoadBalancerId";
    private static final String ELEMENT_ELASTIC_LOAD_BALANCER_NAME = "ElasticLoadBalancerName";
    private static final String ELEMENT_DNS_NAME = "DNSName";
    private static final String ELEMENT_NETWORK_VOLUME = "NetworkVolume";
    private static final String ELEMENT_STATE = "State";
    private static final String ELEMENT_ACCOUNTING_TYPE = "AccountingType";
    private static final String ELEMENT_NEXT_MONTH_ACCOUNTING_TYPE =
        "NextMonthAccountingType";
    private static final String ELEMENT_ELASTIC_LOAD_BALANCER_LISTENER_DESCRIPTIONS =
        "ElasticLoadBalancerListenerDescriptions";
    private static final String ELEMENT_AVAILABILITY_ZONES = "AvailabilityZones";
    private static final String ELEMENT_NETWORK_INTERFACES = "NetworkInterfaces";
    private static final String ELEMENT_VERSION_INFORMATION = "VersionInformation";
    private static final String ELEMENT_IS_LATEST = "IsLatest";
    private static final String ELEMENT_VERSION = "Version";
    private static final String ELEMENT_CREATED_TIME = "CreatedTime";

    /**
     * 変換可能なクラスか判定します。
     *
     * @param type
     *            クラス
     * @return 変換可能な場合true, 変換不可能な場合false
     *
     * @see com.thoughtworks.xstream.converters.Converter#canConvert(Class)
     */
    @SuppressWarnings("rawtypes")
    @Override
    public boolean canConvert(Class type) {
        return type == ElasticLoadBalancerDescriptions.class;
    }

    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer,
        MarshallingContext context) {
        // 処理無し
    }

    /**
     * {@literal
     * ElasticLoadBalancerDescriptionsをElasticLoadBalancerDescriptionsクラスに変換します。}
     *
     * @param reader
     *            XML読込リーダ
     * @param context
     * @return {@literal ElasticLoadBalancerDescriptionsオブジェクト}
     *
     * @see com.thoughtworks.xstream.converters.Converter#unmarshal(HierarchicalStreamReader,
     *      UnmarshallingContext)
     */
    @SuppressWarnings("unchecked")
    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {

        ElasticLoadBalancerDescriptions descriptions = new ElasticLoadBalancerDescriptions();

        List<ElasticLoadBalancerDescriptionsMember> list =
            new ArrayList<ElasticLoadBalancerDescriptionsMember>();

        ElasticLoadBalancerListenerDescriptionsConverter listenerConverter =
            new ElasticLoadBalancerListenerDescriptionsConverter();

        AvailabilityZonesConverter zoneConverter = new AvailabilityZonesConverter();

        NetworkInterfacesConverter networkConverter = new NetworkInterfacesConverter();

        String name = null;

        while (reader.hasMoreChildren()) {

            reader.moveDown();

            name = reader.getNodeName();

            ElasticLoadBalancerDescriptionsMember descriptionMember =
                new ElasticLoadBalancerDescriptionsMember();

            if (name.equals(ELEMENT_MEMBER)) {

                while (reader.hasMoreChildren()) {

                    reader.moveDown();

                    name = reader.getNodeName();

                    if (name.equals(ELEMENT_ELASTIC_LOAD_BALANCER_ID)) {
                        descriptionMember.setElasticLoadBalancerId(reader.getValue());
                    } else if (name.equals(ELEMENT_ELASTIC_LOAD_BALANCER_NAME)) {
                        descriptionMember.setElasticLoadBalancerName(reader.getValue());
                    } else if (name.equals(ELEMENT_DNS_NAME)) {
                        descriptionMember.setDnsName(reader.getValue());
                    } else if (name.equals(ELEMENT_NETWORK_VOLUME)) {
                        descriptionMember.setNetworkVolume(reader.getValue());
                    } else if (name.equals(ELEMENT_STATE)) {
                        descriptionMember.setState(reader.getValue());
                    } else if (name.equals(ELEMENT_ACCOUNTING_TYPE)) {
                        descriptionMember.setAccountingType(reader.getValue());
                    } else if (name.equals(ELEMENT_NEXT_MONTH_ACCOUNTING_TYPE)) {
                        descriptionMember.setNextMonthAccountingType(reader.getValue());
                    } else if (name.equals(ELEMENT_ELASTIC_LOAD_BALANCER_LISTENER_DESCRIPTIONS)) {
                        descriptionMember.setElasticLoadBalancerListenerDescriptions(
                            (ElasticLoadBalancerListenerDescriptions) listenerConverter
                                .unmarshal(reader, context));
                    } else if (name.equals(ELEMENT_AVAILABILITY_ZONES)) {
                        descriptionMember.setAvailabilityZones(
                            (AvailabilityZones) zoneConverter.unmarshal(reader, context));
                    } else if (name.equals(ELEMENT_NETWORK_INTERFACES)) {
                        descriptionMember.setNetworkInterfaces(
                            (List<NetworkInterface>) networkConverter.unmarshal(reader, context));
                    } else if (name.equals(ELEMENT_VERSION_INFORMATION)) {

                        VersionInformation info = new VersionInformation();

                        while (reader.hasMoreChildren()) {

                            reader.moveDown();

                            name = reader.getNodeName();

                            if (name.equals(ELEMENT_IS_LATEST)) {
                                info.setLatest(Boolean.parseBoolean(reader.getValue()));
                            } else if (name.equals(ELEMENT_VERSION)) {
                                info.setVersion(reader.getValue());
                            }

                            reader.moveUp();

                        }

                        descriptionMember.setVersionInformation(info);

                    } else if (name.equals(ELEMENT_CREATED_TIME)) {
                        descriptionMember.setCreatedTime(reader.getValue());
                    }

                    reader.moveUp();

                }

            }

            list.add(descriptionMember);

            reader.moveUp();

        }

        descriptions.setMember(list);

        return descriptions;
    }

}
