/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model;

import com.thoughtworks.xstream.annotations.XStreamAlias;

/**
 * バージョンインフォメーションクラス。<br />
 * このクラスはバージョン情報を保持します。
 *
 */
public class VersionInformation {

    /** バージョン最新状態 */
    @XStreamAlias("IsLatest")
    private Boolean latest;

    /** バージョン情報 */
    @XStreamAlias("Version")
    private String version;

    /**
     * バージョン最新状態を取得します。
     * 
     * @return バージョン最新状態
     */
    public Boolean getLatest() {
        return latest;
    }

    /**
     * バージョン最新状態を設定します。
     * 
     * @param latest
     *            バージョン最新状態
     */
    public void setLatest(Boolean latest) {
        this.latest = latest;
    }

    /**
     * バージョン最新状態を設定し、自オブジェクトを返します。
     * 
     * @param latest
     *            バージョン最新状態
     * @return 自オブジェクト
     */
    public VersionInformation withLatest(Boolean latest) {
        setLatest(latest);
        return this;
    }

    /**
     * バージョン情報を取得します。
     * 
     * @return バージョン情報
     */
    public String getVersion() {
        return version;
    }

    /**
     * バージョン情報を設定します。
     * 
     * @param version
     *            バージョン情報
     */
    public void setVersion(String version) {
        this.version = version;
    }

    /**
     * バージョン情報を設定し、自オブジェクトを返します。
     * 
     * @param version
     *            バージョン情報
     * @return 自オブジェクト
     */
    public VersionInformation withVersion(String version) {
        setVersion(version);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[latest=");
        builder.append(latest);

        builder.append(", version=");
        builder.append(version);

        builder.append("]");

        return builder.toString();
    }

}
