/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model;

import com.nifty.cloud.sdk.annotation.Query;

/**
 * システムIPアドレスクラス. <br />
 * このクラスはシステムIPアドレスを保持します。
 */
public class SystemIpAddress {

    /** システムIPアドレス. */
    private String systemIpAddress;

    /**
     * システムIPアドレスを取得します.
     *
     * @return システムIPアドレス
     */
    @Query(name = "SystemIpAddress")
    public String getSystemIpAddress() {
        return systemIpAddress;
    }

    /**
     * システムIPアドレスを設定します.
     *
     * @param systemIpAddress
     *            システムIPアドレス
     */
    public void setSystemIpAddress(String systemIpAddress) {
        this.systemIpAddress = systemIpAddress;
    }

    /**
     * システムIP青レスを設定し、自オブジェクトを返します.
     *
     * @param systemIpAddress
     *            システムIPアドレス
     * @return 自オブジェクト
     */
    public SystemIpAddress withSystemIpAddress(String systemIpAddress) {
        setSystemIpAddress(systemIpAddress);
        return this;
    }

    /*
     * (non-Javadoc)
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[systemIpAddress=");
        builder.append(systemIpAddress);

        builder.append("]");

        return builder.toString();
    }
}
