/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model;

import com.nifty.cloud.sdk.annotation.Query;

/**
 * 固定設定情報クラス。<br />
 * このクラスは固定設定情報を保持します。
 *
 */
public class StickinessPolicy {

    /** セッション固定オプション利用設定 */
    private Boolean enable;

    /** セッション固定方法 */
    private String method;

    /** セッション保持時間 */
    private Integer expirationPeriod;

    /**
     * セッション固定オプション利用設定を取得します。
     * 
     * @return セッション固定オプション利用設定
     */
    @Query(name = "Enable")
    public Boolean getEnable() {
        return enable;
    }

    /**
     * セッション固定オプション利用設定を設定します。
     * 
     * @param enable
     *            セッション固定オプション利用設定
     */
    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    /**
     * セッション固定オプション利用設定を設定し、自オブジェクトを返します。
     * 
     * @param enable
     *            セッション固定オプション利用設定
     * @return 自オブジェクト
     */
    public StickinessPolicy withEnable(Boolean enable) {
        setEnable(enable);
        return this;
    }

    /**
     * セッション固定方法を取得します。
     * 
     * @return セッション固定方法
     */
    @Query(name = "Method")
    public String getMethod() {
        return method;
    }

    /**
     * セッション固定方法を設定します。
     * 
     * @param method
     *            セッション固定方法
     */
    public void setMethod(String method) {
        this.method = method;
    }

    /**
     * セッション固定方法を設定し、自オブジェクトを返します。
     * 
     * @param method
     *            セッション固定方法
     * @return 自オブジェクト
     */
    public StickinessPolicy withMethod(String method) {
        setMethod(method);
        return this;
    }

    /**
     * セッション保持時間を取得します。
     * 
     * @return セッション保持時間
     */
    @Query(name = "ExpirationPeriod")
    public Integer getExpirationPeriod() {
        return expirationPeriod;
    }

    /**
     * セッション保持時間を設定します。
     * 
     * @param expirationPeriod
     *            セッション保持時間
     */
    public void setExpirationPeriod(Integer expirationPeriod) {
        this.expirationPeriod = expirationPeriod;
    }

    /**
     * セッション保持時間を設定し、自オブジェクトを返します。
     * 
     * @param expirationPeriod
     *            セッション保持時間
     * @return 自オブジェクト
     */
    public StickinessPolicy withExpirationPeriod(Integer expirationPeriod) {
        setExpirationPeriod(expirationPeriod);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[enable=");
        builder.append(enable);
        builder.append(", method=");
        builder.append(method);
        builder.append(", expirationPeriod=");
        builder.append(expirationPeriod);

        builder.append("]");

        return builder.toString();
    }

}
