/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model;

import com.nifty.cloud.sdk.annotation.Query;

/**
 * Sorryページ設定クラス。<br />
 * このクラスはSorryページ設定情報を保持します。
 *
 */

public class SorryPage {

    /** Sorryページオプション利用設定 */
    private Boolean enable;

    /** リダイレクトURL */
    private String redirectUrl;

    /**
     * Sorryページオプション利用設定を取得します。
     * 
     * @return Sorryページオプション利用設定
     */
    @Query(name = "Enable")
    public Boolean getEnable() {
        return enable;
    }

    /**
     * Sorryページオプション利用設定を設定します。
     * 
     * @param enable
     *            Sorryページオプション利用設定
     */
    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    /**
     * Sorryページオプション利用設定を設定し、自オブジェクトを返します。
     * 
     * @param enable
     *            Sorryページオプション利用設定
     * @return 自オブジェクト
     */
    public SorryPage withEnable(Boolean enable) {
        setEnable(enable);
        return this;
    }

    /**
     * リダイレクトURLを取得します。
     * 
     * @return リダイレクトURL
     */
    @Query(name = "RedirectUrl")
    public String getRedirectUrl() {
        return redirectUrl;
    }

    /**
     * リダイレクトURLを設定します。
     * 
     * @param redirectUrl
     *            リダイレクトURL
     */
    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    /**
     * リダイレクトURLを設定し、自オブジェクトを返します。
     * 
     * @param redirectUrl
     *            リダイレクトURL
     * @return 自オブジェクト
     */
    public SorryPage withRedirectUrl(String redirectUrl) {
        setRedirectUrl(redirectUrl);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[enable=");
        builder.append(enable);
        builder.append(", redirectUrl=");
        builder.append(redirectUrl);

        builder.append("]");

        return builder.toString();
    }

}
