/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model;

import com.nifty.cloud.sdk.annotation.Query;

/**
 * セッションクラス。<br />
 * このクラスはセッション情報を保持します。
 *
 */
public class Session {

    /** 固定設定情報 */
    private StickinessPolicy stickinessPolicy;

    /**
     * 固定設定情報を取得します。
     * 
     * @return 固定設定情報
     */
    @Query(name = "StickinessPolicy")
    public StickinessPolicy getStickinessPolicy() {
        return stickinessPolicy;
    }

    /**
     * 固定設定情報を設定します。
     * 
     * @param stickinessPolicy
     *            固定設定情報
     */
    public void setStickinessPolicy(StickinessPolicy stickinessPolicy) {
        this.stickinessPolicy = stickinessPolicy;
    }

    /**
     * 固定設定情報を設定し、自オブジェクトを返します。
     * 
     * @param stickinessPolicy
     *            固定設定情報
     * @return 自オブジェクト
     */
    public Session withStickinessPolicy(StickinessPolicy stickinessPolicy) {
        setStickinessPolicy(stickinessPolicy);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[stickinessPolicy=");
        builder.append(stickinessPolicy);

        builder.append("]");

        return builder.toString();
    }

}
