/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model;

import com.nifty.cloud.sdk.annotation.Query;
import com.thoughtworks.xstream.annotations.XStreamAlias;

/**
 * サーバーメンバークラス。<br />
 * このクラスはサーバーのメンバー情報を格納します。
 */
public class ServerMember {

    /** サーバーユニークID */
    @XStreamAlias("InstanceUniqueId")
    private String instanceUniqueId;

    /** サーバー名 */
    @XStreamAlias("InstanceId")
    private String instanceId;

    /** ヘルスステータス */
    @XStreamAlias("State")
    private String state;

    /** 理由コード */
    @XStreamAlias("ReasonCode")
    private String reasonCode;

    /** 説明文 */
    @XStreamAlias("Description")
    private String description;

    /**
     * サーバーユニークIDを取得します。
     * 
     * @return サーバーユニークID
     */
    @Query(name = "InstanceUniqueId")
    public String getInstanceUniqueId() {
        return instanceUniqueId;
    }

    /**
     * サーバーユニークIDを設定します。
     * 
     * @param instanceUniqueId
     *            サーバーユニークID
     */
    public void setInstanceUniqueId(String instanceUniqueId) {
        this.instanceUniqueId = instanceUniqueId;
    }

    /**
     * サーバーユニークIDを設定し、自オブジェクトを返します。
     * 
     * @param instanceUniqueId
     *            サーバーユニークID
     * @return 自オブジェクト
     */
    public ServerMember withInstanceUniqueId(String instanceUniqueId) {
        setInstanceUniqueId(instanceUniqueId);
        return this;
    }

    /**
     * サーバー名を取得します。
     * 
     * @return サーバー名
     */
    @Query(name = "InstanceId")
    public String getInstanceId() {
        return instanceId;
    }

    /**
     * サーバー名を設定します。
     * 
     * @param instanceId
     *            サーバー名
     */
    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    /**
     * サーバー名を設定し、自オブジェクトを返します。
     * 
     * @param instanceId
     *            サーバー名
     * @return 自オブジェクト
     */
    public ServerMember withInstanceId(String instanceId) {
        setInstanceId(instanceId);
        return this;
    }

    /**
     * ヘルスステータスを取得します。
     * 
     * @return ヘルスステータス
     */
    public String getState() {
        return state;
    }

    /**
     * ヘルスステータスを設定します。
     * 
     * @param state
     *            ヘルスステータス
     */
    public void setState(String state) {
        this.state = state;
    }

    /**
     * ヘルスステータスを設定し、自オブジェクトを返します。
     * 
     * @param state
     *            ヘルスステータス
     * @return 自オブジェクト
     */
    public ServerMember withState(String state) {
        setState(state);
        return this;
    }

    /**
     * reasonCodeを取得します。
     * 
     * @return reasonCode
     */
    public String getReasonCode() {
        return reasonCode;
    }

    /**
     * reasonCodeを設定します。
     * 
     * @param reasonCode
     */
    public void setReasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
    }

    /**
     * reasonCodeを設定し、自オブジェクトを返します。
     * 
     * @param reasonCode
     * @return 自オブジェクト
     */
    public ServerMember withReasonCode(String reasonCode) {
        setReasonCode(reasonCode);
        return this;
    }

    /**
     * descriptionを取得します。
     * 
     * @return description
     */
    public String getDescription() {
        return description;
    }

    /**
     * descriptionを設定します。
     * 
     * @param description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * descriptionを設定し、自オブジェクトを返します。
     * 
     * @param description
     * @return 自オブジェクト
     */
    public ServerMember withDescription(String description) {
        setDescription(description);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[instanceUniqueId=");
        builder.append(instanceUniqueId);
        builder.append("instanceId=");
        builder.append(instanceId);
        builder.append("state=");
        builder.append(state);
        builder.append("reasonCode=");
        builder.append(reasonCode);
        builder.append("description=");
        builder.append(description);

        builder.append("]");

        return builder.toString();

    }

}
