/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model;

import com.nifty.cloud.sdk.annotation.Query;
import com.thoughtworks.xstream.annotations.XStreamAlias;

/**
 * レスポンスリスナーメンバークラス。<br />
 * このクラスはマルチロードバランサーのポート設定情報を保持します。
 *
 */
public class ResponseListenerMember {

    /** プロトコル */
    @XStreamAlias("Protocol")
    private String protocol;

    /** 待ち受けポート */
    @XStreamAlias("ElasticLoadBalancerPort")
    private Integer elasticLoadBalancerPort;

    /** 宛先ポート */
    @XStreamAlias("InstancePort")
    private Integer instancePort;

    /** ロードバランス方式 */
    @XStreamAlias("BalancingType")
    private String balancingType;

    /** マルチロードバランサーのメモ情報 */
    @XStreamAlias("Description")
    private String description;

    /**
     * プロトコルを取得します。
     * 
     * @return プロトコル
     */
    @Query(name = "Protocol")
    public String getProtocol() {
        return protocol;
    }

    /**
     * プロトコルを設定します。
     * 
     * @param protocol
     *            プロトコル
     */
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    /**
     * プロトコルを設定し、自オブジェクトを返します。
     * 
     * @param protocol
     *            プロトコル
     * @return 自オブジェクト
     */
    public ResponseListenerMember withProtocol(String protocol) {
        setProtocol(protocol);
        return this;
    }

    /**
     * 待ち受けポートを取得します。
     * 
     * @return 待ち受けポート
     */
    @Query(name = "ElasticLoadBalancerPort")
    public Integer getElasticLoadBalancerPort() {
        return elasticLoadBalancerPort;
    }

    /**
     * 待ち受けポートを設定します。
     * 
     * @param elasticLoadBalancerPort
     *            待ち受けポート
     */
    public void setElasticLoadBalancerPort(Integer elasticLoadBalancerPort) {
        this.elasticLoadBalancerPort = elasticLoadBalancerPort;
    }

    /**
     * 待ち受けポートを設定し、自オブジェクトを返します。
     * 
     * @param elasticLoadBalancerPort
     *            待ち受けポート
     * @return 自オブジェクト
     */
    public ResponseListenerMember withElasticLoadBalancerPort(Integer elasticLoadBalancerPort) {
        setElasticLoadBalancerPort(elasticLoadBalancerPort);
        return this;
    }

    /**
     * 宛先ポートを取得します。
     * 
     * @return 宛先ポート
     */
    @Query(name = "InstancePort")
    public Integer getInstancePort() {
        return instancePort;
    }

    /**
     * 宛先ポートを設定します。
     * 
     * @param instancePort
     *            宛先ポート
     */
    public void setInstancePort(Integer instancePort) {
        this.instancePort = instancePort;
    }

    /**
     * 宛先ポートを設定し、自オブジェクトを返します。
     * 
     * @param instancePort
     *            宛先ポート
     * @return 自オブジェクト
     */
    public ResponseListenerMember withInstancePort(Integer instancePort) {
        setInstancePort(instancePort);
        return this;
    }

    /**
     * ロードバランス方式を取得します。
     * 
     * @return ロードバランス方式
     */
    @Query(name = "BalancingType")
    public String getBalancingType() {
        return balancingType;
    }

    /**
     * ロードバランス方式を設定します。
     * 
     * @param balancingType
     *            ロードバランス方式
     */
    public void setBalancingType(String balancingType) {
        this.balancingType = balancingType;
    }

    /**
     * ロードバランス方式を設定し、自オブジェクトを返します。
     * 
     * @param balancingType
     *            ロードバランス方式
     * @return 自オブジェクト
     */
    public ResponseListenerMember withBalancingType(String balancingType) {
        setBalancingType(balancingType);
        return this;
    }

    /**
     * マルチロードバランサーのメモ情報を取得します。
     * 
     * @return マルチロードバランサーのメモ情報
     */
    @Query(name = "Description")
    public String getDescription() {
        return description;
    }

    /**
     * マルチロードバランサーのメモ情報を設定します。
     * 
     * @param description
     *            マルチロードバランサーのメモ情報
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * マルチロードバランサーのメモ情報を設定し、自オブジェクトを返します。
     * 
     * @param description
     *            マルチロードバランサーのメモ情報
     * @return 自オブジェクト
     */
    public ResponseListenerMember withDescription(String description) {
        setDescription(description);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[protocol=");
        builder.append(protocol);
        builder.append(", elasticLoadBalancerPort=");
        builder.append(elasticLoadBalancerPort);
        builder.append(", instancePort=");
        builder.append(instancePort);
        builder.append(", balancingType=");
        builder.append(balancingType);
        builder.append(", description=");
        builder.append(description);

        builder.append("]");

        return builder.toString();
    }

}
