/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.annotation.Query;
import com.thoughtworks.xstream.annotations.XStreamAlias;

/**
 * レスポンスリスナークラス。<br />
 * このクラスはマルチロードバランサーのポート設定情報のリストを保持します。
 *
 */
public class ResponseListener {

    /** マルチロードバランサーのポート設定情報 */
    @XStreamAlias("member")
    private List<ResponseListenerMember> member;

    /**
     * マルチロードバランサーのポート設定情報を取得します。
     * 
     * @return マルチロードバランサーのポート設定情報
     */
    @Query(name = "member")
    public List<ResponseListenerMember> getMember() {
        return member;
    }

    /**
     * マルチロードバランサーのポート設定情報を設定します。
     * 
     * @param member
     *            マルチロードバランサーのポート設定情報
     */
    public void setMember(List<ResponseListenerMember> member) {
        this.member = member;
    }

    /**
     * マルチロードバランサーのポート設定情報を設定し、自オブジェクトを返します。
     * 
     * @param member
     *            マルチロードバランサーのポート設定情報
     * @return 自オブジェクト
     */
    public ResponseListener withMember(ResponseListenerMember... member) {

        if (this.member == null) {
            this.member = new ArrayList<ResponseListenerMember>();
        }

        if (member != null && member.length > 0) {

            for (ResponseListenerMember work : member) {
                getMember().add(work);
            }

        }

        return this;
    }

    /**
     * マルチロードバランサーのポート設定情報を設定し、自オブジェクトを返します。
     * 
     * @param member
     *            マルチロードバランサーのポート設定情報
     * @return 自オブジェクト
     */
    public ResponseListener withMember(Collection<ResponseListenerMember> member) {

        if (this.member == null) {
            this.member = new ArrayList<ResponseListenerMember>();
        }

        if (member != null && !member.isEmpty()) {
            getMember().addAll(member);
        }

        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[member=");
        builder.append(member);

        builder.append("]");

        return builder.toString();
    }

}
