/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model;

import com.nifty.cloud.sdk.multiloadbalancer.model.transform.ExpectationConverter;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;

/**
 * ResponseHealthCheckクラス。<br />
 * このクラスはレスポンスのヘルスチェック情報を格納します。
 *
 */
public class ResponseHealthCheck {

    /** ヘルスチェック プロトコル */
    @XStreamAlias("Target")
    private String target;

    /** ヘルスチェック間隔(秒) */
    @XStreamAlias("Interval")
    private Integer interval;

    /** タイムアウト時間 */
    @XStreamAlias("Timeout")
    private Integer timeout;

    /** ヘルスチェック間隔(秒) */
    @XStreamAlias("UnhealthyThreshold")
    private Integer unhealthyThreshold;

    /** ヘルスチェックの復旧判断 */
    @XStreamAlias("HealthyThreshold")
    private Integer healthyThreshold;

    /** ヘルスチェックパス */
    @XStreamAlias("Path")
    private String path;

    /** ヘルスチェック期待値セット */
    @XStreamAlias("Expectation")
    @XStreamConverter(ExpectationConverter.class)
    private Expectation expectation;

    /**
     * ヘルスチェック プロトコルを取得します。
     * 
     * @return ヘルスチェック プロトコル
     */
    public String getTarget() {
        return target;
    }

    /**
     * ヘルスチェック プロトコルを設定します。
     * 
     * @param target
     *            ヘルスチェック プロトコル
     */
    public void setTarget(String target) {
        this.target = target;
    }

    /**
     * ヘルスチェック プロトコルを設定し、自オブジェクトを返します。
     * 
     * @param target
     *            ヘルスチェック プロトコル
     * @return 自オブジェクト
     */
    public ResponseHealthCheck withTarget(String target) {
        setTarget(target);
        return this;
    }

    /**
     * ヘルスチェック間隔(秒)を取得します。
     * 
     * @return ヘルスチェック間隔(秒)
     */
    public Integer getInterval() {
        return interval;
    }

    /**
     * ヘルスチェック間隔(秒)を設定します。
     * 
     * @param interval
     *            ヘルスチェック間隔(秒)
     */
    public void setInterval(Integer interval) {
        this.interval = interval;
    }

    /**
     * ヘルスチェック間隔(秒)を設定し、自オブジェクトを返します。
     * 
     * @param interval
     *            ヘルスチェック間隔(秒)
     * @return 自オブジェクト
     */
    public ResponseHealthCheck withInterval(Integer interval) {
        setInterval(interval);
        return this;
    }

    /**
     * タイムアウト時間を取得します。
     * 
     * @return タイムアウト時間
     */
    public Integer getTimeout() {
        return timeout;
    }

    /**
     * タイムアウト時間を設定します。
     * 
     * @param timeout
     *            タイムアウト時間
     */
    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    /**
     * タイムアウト時間を設定し、自オブジェクトを返します。
     * 
     * @param timeout
     *            タイムアウト時間
     * @return 自オブジェクト
     */
    public ResponseHealthCheck withTimeout(Integer timeout) {
        setTimeout(timeout);
        return this;
    }

    /**
     * ヘルスチェック間隔(秒)を取得します。
     * 
     * @return ヘルスチェック間隔(秒)
     */
    public Integer getUnhealthyThreshold() {
        return unhealthyThreshold;
    }

    /**
     * ヘルスチェック間隔(秒)を設定します。
     * 
     * @param unhealthyThreshold
     *            ヘルスチェック間隔(秒)
     */
    public void setUnhealthyThreshold(Integer unhealthyThreshold) {
        this.unhealthyThreshold = unhealthyThreshold;
    }

    /**
     * ヘルスチェック間隔(秒)を設定し、自オブジェクトを返します。
     * 
     * @param unhealthyThreshold
     *            ヘルスチェック間隔(秒)
     * @return 自オブジェクト
     */
    public ResponseHealthCheck withUnhealthyThreshold(Integer unhealthyThreshold) {
        setUnhealthyThreshold(unhealthyThreshold);
        return this;
    }

    /**
     * ヘルスチェックの復旧判断を取得します。
     * 
     * @return ヘルスチェックの復旧判断
     */
    public Integer getHealthyThreshold() {
        return healthyThreshold;
    }

    /**
     * ヘルスチェックの復旧判断を設定します。
     * 
     * @param healthyThreshold
     *            ヘルスチェックの復旧判断
     */
    public void setHealthyThreshold(Integer healthyThreshold) {
        this.healthyThreshold = healthyThreshold;
    }

    /**
     * ヘルスチェックの復旧判断を設定し、自オブジェクトを返します。
     * 
     * @param healthyThreshold
     *            ヘルスチェックの復旧判断
     * @return 自オブジェクト
     */
    public ResponseHealthCheck withHealthyThreshold(Integer healthyThreshold) {
        setHealthyThreshold(healthyThreshold);
        return this;
    }

    /**
     * ヘルスチェックパスを取得します。
     * 
     * @return ヘルスチェックパス
     */
    public String getPath() {
        return path;
    }

    /**
     * ヘルスチェックパスを設定します。
     * 
     * @param path
     *            ヘルスチェックパス
     */
    public void setPath(String path) {
        this.path = path;
    }

    /**
     * ヘルスチェックパスを設定し、自オブジェクトを返します。
     * 
     * @param path
     *            ヘルスチェックパス
     * @return 自オブジェクト
     */
    public ResponseHealthCheck withPath(String path) {
        setPath(path);
        return this;
    }

    /**
     * ヘルスチェック期待値セットを取得します。
     * 
     * @return ヘルスチェック期待値セット
     */
    public Expectation getExpectation() {
        return expectation;
    }

    /**
     * ヘルスチェック期待値セットを設定します。
     * 
     * @param expectation
     *            ヘルスチェック期待値セット
     */
    public void setExpectation(Expectation expectation) {
        this.expectation = expectation;
    }

    /**
     * ヘルスチェック期待値セットを設定し、自オブジェクトを返します。
     * 
     * @param expectation
     *            ヘルスチェック期待値セット
     * @return 自オブジェクト
     */
    public ResponseHealthCheck withExpectation(Expectation expectation) {
        setExpectation(expectation);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[target=");
        builder.append(target);

        builder.append(", interval=");
        builder.append(interval);

        builder.append(", timeout=");
        builder.append(timeout);

        builder.append(", unhealthyThreshold=");
        builder.append(unhealthyThreshold);

        builder.append(", healthyThreshold=");
        builder.append(healthyThreshold);

        builder.append(", path=");
        builder.append(path);

        builder.append(", expectation=");
        builder.append(expectation);

        builder.append("]");

        return builder.toString();
    }

}
