/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model;

import com.nifty.cloud.sdk.annotation.Query;

/**
 * RequestListenerCreateMemberクラス。<br />
 * このクラスは新規作成時のマルチロードバランサー情報を保持します。
 *
 */
public class RequestListenerCreateMember {

    /** プロトコル */
    private String protocol;

    /** 待ち受けポート */
    private Integer elasticLoadBalancerPort;

    /** 宛先ポート */
    private Integer instancePort;

    /** ロードバランス方式 */
    private String balancingType;

    /** マルチロードバランサーのメモ情報 */
    private String description;

    /** サーバー情報 */
    private Instance instances;

    /** ヘルスチェック情報 */
    private HealthCheck healthCheck;

    /** SSL証明書の発行識別子 */
    private String sslCertificateId;

    /** セッション情報 */
    private Session session;

    /** Sorryページ設定 */
    private SorryPage sorryPage;

    /**
     * プロトコルを取得します。
     * 
     * @return プロトコル
     */
    @Query(name = "Protocol")
    public String getProtocol() {
        return protocol;
    }

    /**
     * プロトコルを設定します。
     * 
     * @param protocol
     *            プロトコル
     */
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    /**
     * プロトコルを設定し、自オブジェクトを返します。
     * 
     * @param protocol
     *            プロトコル
     * @return 自オブジェクト
     */
    public RequestListenerCreateMember withProtocol(String protocol) {
        setProtocol(protocol);
        return this;
    }

    /**
     * 待ち受けポートを設定します。
     * 
     * @return 待ち受けポート
     */
    @Query(name = "ElasticLoadBalancerPort")
    public Integer getElasticLoadBalancerPort() {
        return elasticLoadBalancerPort;
    }

    /**
     * 待ち受けポートを設定します。
     * 
     * @param elasticLoadBalancerPort
     *            待ち受けポート
     */
    public void setElasticLoadBalancerPort(Integer elasticLoadBalancerPort) {
        this.elasticLoadBalancerPort = elasticLoadBalancerPort;
    }

    /**
     * 待ち受けポートを設定し、自オブジェクトを返します。
     * 
     * @param elasticLoadBalancerPort
     *            待ち受けポート
     * @return 自オブジェクト
     */
    public RequestListenerCreateMember
        withElasticLoadBalancerPort(Integer elasticLoadBalancerPort) {
        setElasticLoadBalancerPort(elasticLoadBalancerPort);
        return this;
    }

    /**
     * 宛先ポートを取得します。
     * 
     * @return 宛先ポート
     */
    @Query(name = "InstancePort")
    public Integer getInstancePort() {
        return instancePort;
    }

    /**
     * 宛先ポートを設定します。
     * 
     * @param instancePort
     *            宛先ポート
     */
    public void setInstancePort(Integer instancePort) {
        this.instancePort = instancePort;
    }

    /**
     * 宛先ポートを設定し、自オブジェクトを返します。
     * 
     * @param instancePort
     *            宛先ポート
     * @return 自オブジェクト
     */
    public RequestListenerCreateMember withInstancePort(Integer instancePort) {
        setInstancePort(instancePort);
        return this;
    }

    /**
     * ロードバランス方式を取得します。
     * 
     * @return ロードバランス方式
     */
    @Query(name = "BalancingType")
    public String getBalancingType() {
        return balancingType;
    }

    /**
     * ロードバランス方式を設定します。
     * 
     * @param balancingType
     *            ロードバランス方式
     */
    public void setBalancingType(String balancingType) {
        this.balancingType = balancingType;
    }

    /**
     * ロードバランス方式を設定し、自オブジェクトを返します。
     * 
     * @param balancingType
     *            ロードバランス方式
     * @return 自オブジェクト
     */
    public RequestListenerCreateMember withBalancingType(String balancingType) {
        setBalancingType(balancingType);
        return this;
    }

    /**
     * マルチロードバランサーのメモ情報を取得します。
     * 
     * @return マルチロードバランサーのメモ情報
     */
    @Query(name = "Description")
    public String getDescription() {
        return description;
    }

    /**
     * マルチロードバランサーのメモ情報を設定します。
     * 
     * @param description
     *            マルチロードバランサーのメモ情報
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * マルチロードバランサーのメモ情報を設定し、自オブジェクトを返します。
     * 
     * @param description
     *            マルチロードバランサーのメモ情報
     * @return 自オブジェクト
     */
    public RequestListenerCreateMember withDescription(String description) {
        setDescription(description);
        return this;
    }

    /**
     * サーバー情報を取得します。
     * 
     * @return サーバー情報
     */
    @Query(name = "Instances")
    public Instance getInstances() {
        return instances;
    }

    /**
     * サーバー情報を設定します。
     * 
     * @param instances
     *            サーバー情報
     */
    public void setInstances(Instance instances) {
        this.instances = instances;
    }

    /**
     * サーバー情報を設定し、自オブジェクトを返します。
     * 
     * @param instances
     *            サーバー情報
     * @return 自オブジェクト
     */
    public RequestListenerCreateMember withInstances(Instance instances) {
        setInstances(instances);
        return this;
    }

    /**
     * ヘルスチェック情報を取得します。
     * 
     * @return ヘルスチェック情報
     */
    @Query(name = "HealthCheck")
    public HealthCheck getHealthCheck() {
        return healthCheck;
    }

    /**
     * ヘルスチェック情報を設定します。
     * 
     * @param healthCheck
     *            ヘルスチェック情報
     */
    public void setHealthCheck(HealthCheck healthCheck) {
        this.healthCheck = healthCheck;
    }

    /**
     * ヘルスチェック情報を設定し、自オブジェクトを返します。
     * 
     * @param healthCheck
     *            ヘルスチェック情報
     * @return 自オブジェクト
     */
    public RequestListenerCreateMember withHealthCheck(HealthCheck healthCheck) {
        setHealthCheck(healthCheck);
        return this;
    }

    /**
     * SSL証明書の発行識別子を取得します。
     * 
     * @return SSL証明書の発行識別子
     */
    @Query(name = "SSLCertificateId")
    public String getSslCertificateId() {
        return sslCertificateId;
    }

    /**
     * SSL証明書の発行識別子を設定します。
     * 
     * @param sslCertificateId
     *            SSL証明書の発行識別子
     */
    public void setSslCertificateId(String sslCertificateId) {
        this.sslCertificateId = sslCertificateId;
    }

    /**
     * SSL証明書の発行識別子を設定し、自オブジェクトを返します。
     * 
     * @param sslCertificateId
     *            SSL証明書の発行識別子
     * @return 自オブジェクト
     */
    public RequestListenerCreateMember withSslCertificateId(String sslCertificateId) {
        setSslCertificateId(sslCertificateId);
        return this;
    }

    /**
     * セッション情報を取得します。
     * 
     * @return セッション情報
     */
    @Query(name = "Session")
    public Session getSession() {
        return session;
    }

    /**
     * セッション情報を設定します。
     * 
     * @param session
     *            セッション情報
     */
    public void setSession(Session session) {
        this.session = session;
    }

    /**
     * セッション情報を設定し、自オブジェクトを返します。
     * 
     * @param session
     *            セッション情報
     * @return 自オブジェクト
     */
    public RequestListenerCreateMember withSession(Session session) {
        setSession(session);
        return this;
    }

    /**
     * Sorryページ設定を取得します。
     * 
     * @return Sorryページ設定
     */
    @Query(name = "SorryPage")
    public SorryPage getSorryPage() {
        return sorryPage;
    }

    /**
     * Sorryページ設定を設定します。
     * 
     * @param sorryPage
     *            Sorryページ設定
     */
    public void setSorryPage(SorryPage sorryPage) {
        this.sorryPage = sorryPage;
    }

    /**
     * Sorryページ設定を設定し、自オブジェクトを返します。
     * 
     * @param sorryPage
     *            Sorryページ設定
     * @return 自オブジェクト
     */
    public RequestListenerCreateMember withSorryPage(SorryPage sorryPage) {
        setSorryPage(sorryPage);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[protocol=");
        builder.append(protocol);
        builder.append(", elasticLoadBalancerPort=");
        builder.append(elasticLoadBalancerPort);
        builder.append(", instancePort=");
        builder.append(instancePort);
        builder.append(", balancingType=");
        builder.append(balancingType);
        builder.append(", description=");
        builder.append(description);
        builder.append(", instances=");
        builder.append(instances);
        builder.append(", healthCheck=");
        builder.append(healthCheck);
        builder.append(", sslCertificateId=");
        builder.append(sslCertificateId);
        builder.append(", session=");
        builder.append(session);
        builder.append(", sorryPage=");
        builder.append(sorryPage);

        builder.append("]");

        return builder.toString();
    }
}
