/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.annotation.Query;

/**
 * RequestListenerCreateクラス。<br />
 * このクラスはRequestListenerCreateMemberのリストを保持します。
 *
 */
public class RequestListenerCreate {

    /** リスナーメンバーリスト */
    private List<RequestListenerCreateMember> memberList;

    /**
     * リスナーメンバーリストを取得します。
     * 
     * @return リスナーメンバーリスト
     */
    @Query(name = "member")
    public List<RequestListenerCreateMember> getMemberList() {
        return memberList;
    }

    /**
     * リスナーメンバーリストを設定します。
     * 
     * @param memberList
     *            リスナーメンバーリスト
     */
    public void setMemberList(List<RequestListenerCreateMember> memberList) {
        this.memberList = memberList;
    }

    /**
     * リスナーメンバーリストを設定し、自オブジェクトを返します。
     * 
     * @param memberList
     *            リスナーメンバーリスト
     * @return 自オブジェクト
     */
    public RequestListenerCreate withMember(Collection<RequestListenerCreateMember> memberList) {

        if (this.memberList == null) {
            this.memberList = new ArrayList<RequestListenerCreateMember>();
        }

        if (memberList != null && !memberList.isEmpty()) {
            getMemberList().addAll(memberList);
        }

        return this;
    }

    /**
     * リスナーメンバーの配列を設定し、自オブジェクトを返します。
     * 
     * @param member
     *            リスナーメンバーの配列
     * @return 自オブジェクト
     */
    public RequestListenerCreate withMember(RequestListenerCreateMember... member) {

        if (this.memberList == null) {
            this.memberList = new ArrayList<RequestListenerCreateMember>();
        }

        if (member != null && member.length > 0) {

            for (RequestListenerCreateMember work : member) {
                getMemberList().add(work);
            }

        }

        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[memberList=");
        builder.append(memberList);

        builder.append("]");

        return builder.toString();
    }

}
