/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.annotation.Query;
import com.thoughtworks.xstream.annotations.XStreamAlias;

/**
 * リクエストリスナークラス。<br />
 * このクラスはRequestListenerMemberのリストを保持します。
 *
 */
public class RequestListener {

    /** リスナーメンバー */
    @XStreamAlias("member")
    private List<RequestListenerMember> member;

    /**
     * リスナーメンバーを取得します。
     * 
     * @return リスナーメンバー
     */
    @Query(name = "member")
    public List<RequestListenerMember> getMember() {
        return member;
    }

    /**
     * リスナーメンバーを設定します。
     * 
     * @param member
     *            リスナーメンバー
     */
    public void setMember(List<RequestListenerMember> member) {
        this.member = member;
    }

    /**
     * リスナーメンバーの配列を設定し、自オブジェクトを返します。
     * 
     * @param member
     *            リスナーメンバーの配列
     * @return 自オブジェクト
     */
    public RequestListener withMember(RequestListenerMember... member) {

        if (this.member == null) {
            this.member = new ArrayList<RequestListenerMember>();
        }

        for (RequestListenerMember work : member) {
            getMember().add(work);
        }

        return this;
    }

    /**
     * リスナーメンバーを設定し、自オブジェクトを返します。
     * 
     * @param member
     *            リスナーメンバー
     * @return 自オブジェクト
     */
    public RequestListener withMember(Collection<RequestListenerMember> member) {

        if (this.member == null) {
            this.member = new ArrayList<RequestListenerMember>();
        }

        if (member != null && !member.isEmpty()) {
            getMember().addAll(member);
        }

        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[member=");
        builder.append(member);

        builder.append("]");

        return builder.toString();
    }

}
