/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.annotation.Query;

/**
 * RequestExpectationクラス。<br />
 * このクラスはリクエストのヘルスチェック期待値情報を格納します。
 *
 */
public class RequestExpectation {

    /** ヘルスチェック期待値情報 */
    private List<HttpMember> member = new ArrayList<HttpMember>();

    /**
     * ヘルスチェック期待値情報を取得します。
     * 
     * @return ヘルスチェック期待値情報
     */
    @Query(name = "member")
    public List<HttpMember> getMember() {
        return member;
    }

    /**
     * ヘルスチェック期待値情報を設定します。
     * 
     * @param member
     *            ヘルスチェック期待値情報
     */
    public void setMember(List<HttpMember> member) {
        this.member = member;
    }

    /**
     * ヘルスチェック期待値情報を設定し、自オブジェクトを返します。
     * 
     * @param member
     *            ヘルスチェック期待値情報リスト
     * @return 自オブジェクト
     */
    public RequestExpectation withMember(Collection<HttpMember> member) {

        if (this.member == null) {
            this.member = new ArrayList<HttpMember>();
        }

        if (member != null && !member.isEmpty()) {
            getMember().addAll(member);
        }

        return this;
    }

    /**
     * ヘルスチェック期待値情報の配列を設定し、自オブジェクトを返します。
     * 
     * @param member
     *            ヘルスチェック期待値情報の配列
     * @return 自オブジェクト
     */
    public RequestExpectation withMember(HttpMember... member) {

        if (this.member == null) {
            this.member = new ArrayList<HttpMember>();
        }

        if (member != null && member.length > 0) {

            for (HttpMember work : member) {
                getMember().add(work);
            }

        }

        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[member=");
        builder.append(member);

        builder.append("]");

        return builder.toString();
    }

}
