/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model;

import com.nifty.cloud.sdk.ResponseMetadata;
import com.nifty.cloud.sdk.Result;
import com.thoughtworks.xstream.annotations.XStreamAlias;

/**
 * NiftyUpdateElasticLoadBalancer結果処理クラス。<br />
 * このクラスはNiftyUpdateElasticLoadBalancerのレスポンスを格納します。
 */
@XStreamAlias("NiftyUpdateElasticLoadBalancerResponse")
public class NiftyUpdateElasticLoadBalancerResult extends Result {

    /** リクエスト情報 */
    @XStreamAlias("ResponseMetadata")
    private ResponseMetadata responseMetadata;

    /**
     * リクエスト情報を取得します。
     * 
     * @return リクエスト情報
     */
    public ResponseMetadata getResponseMetadata() {
        return responseMetadata;
    }

    /**
     * リクエスト情報を設定します。
     * 
     * @param responseMetadata
     *            リクエスト情報
     */
    public void setResponseMetadata(ResponseMetadata responseMetadata) {
        this.responseMetadata = responseMetadata;
    }

    /**
     * リクエスト情報を設定し、自オブジェクトを返します。
     * 
     * @param responseMetadata
     *            リクエスト情報
     * @return 自オブジェクト
     */
    public NiftyUpdateElasticLoadBalancerResult
        withResponseMetadata(ResponseMetadata responseMetadata) {
        setResponseMetadata(responseMetadata);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[responseMetadata=");
        builder.append(responseMetadata);

        builder.append("]");

        return builder.toString();
    }

}
