/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyUpdateElasticLoadBalancerリクエストクラス。<br />
 * このクラスはNiftyUpdateElasticLoadBalancerへのリクエストを構築します。
 *
 */
@Action("NiftyUpdateElasticLoadBalancer")
public class NiftyUpdateElasticLoadBalancerRequest implements Request {

    /** マルチロードバランサーユニークID */
    private String elasticLoadBalancerId;

    /** マルチロードバランサー名 */
    private String elasticLoadBalancerName;

    /** マルチロードバランサー名の更新値 */
    private String elasticLoadBalancerNameUpdate;

    /** 最大ネットワーク流量の更新値 */
    private Integer networkVolumeUpdate;

    /** 利用料金タイプの更新値 */
    private Integer accountingTypeUpdate;

    /**
     * マルチロードバランサーユニークIDを取得します。
     * 
     * @return マルチロードバランサーユニークID
     */
    @Query(name = "ElasticLoadBalancerId")
    public String getElasticLoadBalancerId() {
        return elasticLoadBalancerId;
    }

    /**
     * マルチロードバランサーユニークIDを設定します。
     * 
     * @param elasticLoadBalancerId
     *            マルチロードバランサーユニークID
     */
    public void setElasticLoadBalancerId(String elasticLoadBalancerId) {
        this.elasticLoadBalancerId = elasticLoadBalancerId;
    }

    /**
     * マルチロードバランサーユニークIDを設定し、自オブジェクトを返します。
     * 
     * @param elasticLoadBalancerId
     *            マルチロードバランサーユニークID
     * @return 自オブジェクト
     */
    public NiftyUpdateElasticLoadBalancerRequest
        withElasticLoadBalancerId(String elasticLoadBalancerId) {
        setElasticLoadBalancerId(elasticLoadBalancerId);
        return this;
    }

    /**
     * マルチロードバランサー名を取得します。
     * 
     * @return マルチロードバランサー名
     */
    @Query(name = "ElasticLoadBalancerName")
    public String getElasticLoadBalancerName() {
        return elasticLoadBalancerName;
    }

    /**
     * マルチロードバランサー名を設定します。
     * 
     * @param elasticLoadBalancerName
     *            マルチロードバランサー名
     */
    public void setElasticLoadBalancerName(String elasticLoadBalancerName) {
        this.elasticLoadBalancerName = elasticLoadBalancerName;
    }

    /**
     * マルチロードバランサー名を設定し、自オブジェクトを返します。
     * 
     * @param elasticLoadBalancerName
     *            マルチロードバランサー名
     * @return 自オブジェクト
     */
    public NiftyUpdateElasticLoadBalancerRequest
        withElasticLoadBalancerName(String elasticLoadBalancerName) {
        setElasticLoadBalancerName(elasticLoadBalancerName);
        return this;
    }

    /**
     * マルチロードバランサー名の更新値を取得します。
     * 
     * @return マルチロードバランサー名の更新値
     */
    @Query(name = "ElasticLoadBalancerNameUpdate")
    public String getElasticLoadBalancerNameUpdate() {
        return elasticLoadBalancerNameUpdate;
    }

    /**
     * マルチロードバランサー名の更新値を設定します。
     * 
     * @param elasticLoadBalancerNameUpdate
     *            マルチロードバランサー名の更新値
     */
    public void setElasticLoadBalancerNameUpdate(String elasticLoadBalancerNameUpdate) {
        this.elasticLoadBalancerNameUpdate = elasticLoadBalancerNameUpdate;
    }

    /**
     * マルチロードバランサー名の更新値を設定し、自オブジェクトを返します。
     * 
     * @param elasticLoadBalancerNameUpdate
     *            マルチロードバランサー名の更新値
     * @return 自オブジェクト
     */
    public NiftyUpdateElasticLoadBalancerRequest
        withElasticLoadBalancerNameUpdate(String elasticLoadBalancerNameUpdate) {
        setElasticLoadBalancerNameUpdate(elasticLoadBalancerNameUpdate);
        return this;
    }

    /**
     * 最大ネットワーク流量の更新値を取得します。
     * 
     * @return 最大ネットワーク流量の更新値
     */
    @Query(name = "NetworkVolumeUpdate")
    public Integer getNetworkVolumeUpdate() {
        return networkVolumeUpdate;
    }

    /**
     * 最大ネットワーク流量の更新値を設定します。
     * 
     * @param networkVolumeUpdate
     *            最大ネットワーク流量の更新値
     */
    public void setNetworkVolumeUpdate(Integer networkVolumeUpdate) {
        this.networkVolumeUpdate = networkVolumeUpdate;
    }

    /**
     * 最大ネットワーク流量の更新値を設定し、自オブジェクトを返します。
     * 
     * @param networkVolumeUpdate
     *            最大ネットワーク流量の更新値
     * @return 自オブジェクト
     */
    public NiftyUpdateElasticLoadBalancerRequest
        withNetworkVolumeUpdate(Integer networkVolumeUpdate) {
        setNetworkVolumeUpdate(networkVolumeUpdate);
        return this;
    }

    /**
     * 利用料金タイプの更新値を取得します。
     * 
     * @return 利用料金タイプの更新値
     */
    @Query(name = "AccountingTypeUpdate")
    public Integer getAccountingTypeUpdate() {
        return accountingTypeUpdate;
    }

    /**
     * 利用料金タイプの更新値を設定します。
     * 
     * @param accountingTypeUpdate
     *            利用料金タイプの更新値
     */
    public void setAccountingTypeUpdate(Integer accountingTypeUpdate) {
        this.accountingTypeUpdate = accountingTypeUpdate;
    }

    /**
     * 利用料金タイプの更新値を設定し、自オブジェクトを返します。
     * 
     * @param accountingTypeUpdate
     *            利用料金タイプの更新値
     * @return 自オブジェクト
     */
    public NiftyUpdateElasticLoadBalancerRequest
        withAccountingTypeUpdate(Integer accountingTypeUpdate) {
        setAccountingTypeUpdate(accountingTypeUpdate);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[elasticLoadBalancerId=");
        builder.append(elasticLoadBalancerId);

        builder.append(", elasticLoadBalancerName=");
        builder.append(elasticLoadBalancerName);

        builder.append(", elasticLoadBalancerNameUpdate=");
        builder.append(elasticLoadBalancerNameUpdate);

        builder.append(", networkVolumeUpdate=");
        builder.append(networkVolumeUpdate);

        builder.append(", accountingTypeUpdate=");
        builder.append(accountingTypeUpdate);

        builder.append("]");

        return builder.toString();
    }

}
