/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyReplaceElasticLoadBalancerListenerSSLCertificateリクエストクラス。<br />
 * このクラスはNiftyReplaceElasticLoadBalancerListenerSSLCertificateへのリクエストを構築します。
 *
 */
@Action("NiftyReplaceElasticLoadBalancerListenerSSLCertificate")
public class NiftyReplaceElasticLoadBalancerListenerSSLCertificateRequest implements Request {

    /** マルチロードバランサーユニークID */
    private String elasticLoadBalancerId;

    /** マルチロードバランサー名 */
    private String elasticLoadBalancerName;

    /** プロトコル */
    private String protocol;

    /** 待ち受けポート */
    private Integer elasticLoadBalancerPort;

    /** 宛先ポート */
    private Integer instancePort;

    /** SSL証明書の発行識別子 */
    private String sslCertificateId;

    /**
     * マルチロードバランサーユニークIDを取得します。
     * 
     * @return マルチロードバランサーユニークID
     */
    @Query(name = "ElasticLoadBalancerId")
    public String getElasticLoadBalancerId() {
        return elasticLoadBalancerId;
    }

    /**
     * マルチロードバランサーユニークIDを設定します。
     * 
     * @param elasticLoadBalancerId
     *            マルチロードバランサーユニークID
     */
    public void setElasticLoadBalancerId(String elasticLoadBalancerId) {
        this.elasticLoadBalancerId = elasticLoadBalancerId;
    }

    /**
     * マルチロードバランサーユニークIDを設定し、自オブジェクトを返します。
     * 
     * @param elasticLoadBalancerId
     *            マルチロードバランサーユニークID
     * @return 自オブジェクト
     */
    public NiftyReplaceElasticLoadBalancerListenerSSLCertificateRequest
        withElasticLoadBalancerId(String elasticLoadBalancerId) {
        setElasticLoadBalancerId(elasticLoadBalancerId);
        return this;
    }

    /**
     * マルチロードバランサー名を取得します。
     * 
     * @return マルチロードバランサー名
     */
    @Query(name = "ElasticLoadBalancerName")
    public String getElasticLoadBalancerName() {
        return elasticLoadBalancerName;
    }

    /**
     * マルチロードバランサー名を設定します。
     * 
     * @param elasticLoadBalancerName
     *            マルチロードバランサー名
     */
    public void setElasticLoadBalancerName(String elasticLoadBalancerName) {
        this.elasticLoadBalancerName = elasticLoadBalancerName;
    }

    /**
     * マルチロードバランサー名を設定し、自オブジェクトを返します。
     * 
     * @param elasticLoadBalancerName
     *            マルチロードバランサー名
     * @return 自オブジェクト
     */
    public NiftyReplaceElasticLoadBalancerListenerSSLCertificateRequest
        withElasticLoadBalancerName(String elasticLoadBalancerName) {
        setElasticLoadBalancerName(elasticLoadBalancerName);
        return this;
    }

    /**
     * プロトコルを取得します。
     * 
     * @return プロトコル
     */
    @Query(name = "Protocol", require = true)
    public String getProtocol() {
        return protocol;
    }

    /**
     * プロトコルを設定します。
     * 
     * @param protocol
     *            プロトコル
     */
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    /**
     * プロトコルを設定し、自オブジェクトを返します。
     * 
     * @param protocol
     *            プロトコル
     * @return 自オブジェクト
     */
    public NiftyReplaceElasticLoadBalancerListenerSSLCertificateRequest
        withProtocol(String protocol) {
        setProtocol(protocol);
        return this;
    }

    /**
     * 待ち受けポートを取得します。
     * 
     * @return 待ち受けポート
     */
    @Query(name = "ElasticLoadBalancerPort", require = true)
    public Integer getElasticLoadBalancerPort() {
        return elasticLoadBalancerPort;
    }

    /**
     * 待ち受けポートを設定します。
     * 
     * @param elasticLoadBalancerPort
     *            待ち受けポート
     */
    public void setElasticLoadBalancerPort(Integer elasticLoadBalancerPort) {
        this.elasticLoadBalancerPort = elasticLoadBalancerPort;
    }

    /**
     * 待ち受けポートを設定し、自オブジェクトを返します。
     * 
     * @param elasticLoadBalancerPort
     *            待ち受けポート
     * @return 自オブジェクト
     */
    public NiftyReplaceElasticLoadBalancerListenerSSLCertificateRequest
        withElasticLoadBalancerPort(Integer elasticLoadBalancerPort) {
        setElasticLoadBalancerPort(elasticLoadBalancerPort);
        return this;
    }

    /**
     * 宛先ポートを取得します。
     * 
     * @return 宛先ポート
     */
    @Query(name = "InstancePort", require = true)
    public Integer getInstancePort() {
        return instancePort;
    }

    /**
     * 宛先ポートを設定します。
     * 
     * @param instancePort
     *            宛先ポート
     */
    public void setInstancePort(Integer instancePort) {
        this.instancePort = instancePort;
    }

    /**
     * 宛先ポートを設定し、自オブジェクトを返します。
     * 
     * @param instancePort
     *            宛先ポート
     * @return 自オブジェクト
     */
    public NiftyReplaceElasticLoadBalancerListenerSSLCertificateRequest
        withInstancePort(Integer instancePort) {
        setInstancePort(instancePort);
        return this;
    }

    /**
     * SSL証明書の発行識別子を取得します。
     * 
     * @return SSL証明書の発行識別子
     */
    @Query(name = "SSLCertificateId", require = true)
    public String getSslCertificateId() {
        return sslCertificateId;
    }

    /**
     * SSL証明書の発行識別子を設定します。
     * 
     * @param sslCertificateId
     *            SSL証明書の発行識別子
     */
    public void setSslCertificateId(String sslCertificateId) {
        this.sslCertificateId = sslCertificateId;
    }

    /**
     * SSL証明書の発行識別子を設定し、自オブジェクトを返します。
     * 
     * @param sslCertificateId
     *            SSL証明書の発行識別子
     * @return 自オブジェクト
     */
    public NiftyReplaceElasticLoadBalancerListenerSSLCertificateRequest
        withSslCertificateId(String sslCertificateId) {
        setSslCertificateId(sslCertificateId);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[elasticLoadBalancerId=");
        builder.append(elasticLoadBalancerId);
        builder.append("elasticLoadBalancerName=");
        builder.append(elasticLoadBalancerName);
        builder.append("protocol=");
        builder.append(protocol);
        builder.append("elasticLoadBalancerPort=");
        builder.append(elasticLoadBalancerPort);
        builder.append("instancePort=");
        builder.append(instancePort);
        builder.append("sslCertificateId=");
        builder.append(sslCertificateId);

        builder.append("]");

        return builder.toString();

    }

}
