/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyReplaceElasticLoadBalancerLatestVersionリクエストクラス。<br />
 * このクラスはNiftyReplaceElasticLoadBalancerLatestVersionへのリクエストを構築します。
 *
 */
@Action("NiftyReplaceElasticLoadBalancerLatestVersion")
public class NiftyReplaceElasticLoadBalancerLatestVersionRequest implements Request {

    /** マルチロードバランサーユニークID */
    private String elasticLoadBalancerId;

    /** マルチロードバランサー名 */
    private String elasticLoadBalancerName;

    /** ネットワークインターフェースリスト. */
    private List<NetworkInterface> networkInterfaceList;

    /**
     * マルチロードバランサーユニークIDを取得します。
     *
     * @return マルチロードバランサーユニークID
     */
    @Query(name = "ElasticLoadBalancerId")
    public String getElasticLoadBalancerId() {
        return elasticLoadBalancerId;
    }

    /**
     * マルチロードバランサーユニークIDを設定します。
     *
     * @param elasticLoadBalancerId
     *            マルチロードバランサーユニークID
     */
    public void setElasticLoadBalancerId(String elasticLoadBalancerId) {
        this.elasticLoadBalancerId = elasticLoadBalancerId;
    }

    /**
     * マルチロードバランサーユニークIDを設定し、自オブジェクトを返します。
     *
     * @param elasticLoadBalancerId
     *            マルチロードバランサーユニークID
     * @return 自オブジェクト
     */
    public NiftyReplaceElasticLoadBalancerLatestVersionRequest
        withElasticLoadBalancerId(String elasticLoadBalancerId) {
        setElasticLoadBalancerId(elasticLoadBalancerId);
        return this;
    }

    /**
     * マルチロードバランサー名を取得します。
     *
     * @return マルチロードバランサー名
     */
    @Query(name = "ElasticLoadBalancerName")
    public String getElasticLoadBalancerName() {
        return elasticLoadBalancerName;
    }

    /**
     * マルチロードバランサー名を設定します。
     *
     * @param elasticLoadBalancerName
     *            マルチロードバランサー名
     */
    public void setElasticLoadBalancerName(String elasticLoadBalancerName) {
        this.elasticLoadBalancerName = elasticLoadBalancerName;
    }

    /**
     * マルチロードバランサー名を設定し、自オブジェクトを返します。
     *
     * @param elasticLoadBalancerName
     *            マルチロードバランサー名
     * @return 自オブジェクト
     */
    public NiftyReplaceElasticLoadBalancerLatestVersionRequest
        withElasticLoadBalancerName(String elasticLoadBalancerName) {
        setElasticLoadBalancerName(elasticLoadBalancerName);
        return this;
    }

    /**
     * ネットワークインタフェースリストを取得します。
     *
     * @return ネットワークインタフェースリスト
     */
    @Query(name = "NetworkInterface")
    public List<NetworkInterface> getNetworkInterfaceList() {
        return networkInterfaceList;
    }

    /**
     * ネットワークインタフェースリストを設定します。
     *
     * @param networkInterfaceList
     *            ネットワークインタフェースリスト
     */
    public void setNetworkInterfaceList(List<NetworkInterface> networkInterfaceList) {
        this.networkInterfaceList = networkInterfaceList;
    }

    /**
     * ネットワークインタフェースリストを設定し、自オブジェクトを返します。
     *
     * @param networkInterfaceList
     *            ネットワークインタフェースリスト
     * @return 自オブジェクト
     */
    public NiftyReplaceElasticLoadBalancerLatestVersionRequest
        withNetworkInterfaceList(Collection<NetworkInterface> networkInterfaceList) {

        if (this.networkInterfaceList == null) {
            this.networkInterfaceList = new ArrayList<NetworkInterface>();
        }

        if (networkInterfaceList != null && !networkInterfaceList.isEmpty()) {
            getNetworkInterfaceList().addAll(networkInterfaceList);
        }

        return this;
    }

    /*
     * (non-Javadoc)
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[elasticLoadBalancerId=");
        builder.append(elasticLoadBalancerId);

        builder.append(", elasticLoadBalancerName=");
        builder.append(elasticLoadBalancerName);

        builder.append(", networkInterfaceList=");
        builder.append(networkInterfaceList);

        builder.append("]");

        return builder.toString();
    }

}
