/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model;

import com.nifty.cloud.sdk.Result;
import com.nifty.cloud.sdk.annotation.Xml2Response;
import com.nifty.cloud.sdk.multiloadbalancer.model.transform.NiftyRegisterPortWithElasticLoadBalancerConverter;
import com.nifty.cloud.sdk.multiloadbalancer.model.transform.NiftyRegisterPortWithElasticLoadBalancerResponse;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;

/**
 * NiftyRegisterPortWithElasticLoadBalancer結果処理クラス。<br />
 * このクラスはNiftyRegisterPortWithElasticLoadBalancerのレスポンスを格納します。
 */
@XStreamConverter(NiftyRegisterPortWithElasticLoadBalancerConverter.class)
@Xml2Response(response = NiftyRegisterPortWithElasticLoadBalancerResponse.class)
public class NiftyRegisterPortWithElasticLoadBalancerResult extends Result {

    /** マルチロードバランサーのポート設定情報セット */
    @XStreamAlias("Listeners")
    private ResponseListener listener;

    /**
     * マルチロードバランサーのポート設定情報セットを取得します。
     * 
     * @return マルチロードバランサーのポート設定情報セット
     */
    public ResponseListener getListener() {
        return listener;
    }

    /**
     * マルチロードバランサーのポート設定情報セットを設定します。
     * 
     * @param listener
     *            マルチロードバランサーのポート設定情報セット
     */
    public void setListener(ResponseListener listener) {
        this.listener = listener;
    }

    /**
     * マルチロードバランサーのポート設定情報セットを設定し、自オブジェクトを返します。
     * 
     * @param listener
     *            マルチロードバランサーのポート設定情報セット
     * @return 自オブジェクト
     */
    public NiftyRegisterPortWithElasticLoadBalancerResult withListener(ResponseListener listener) {
        setListener(listener);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[listener=");
        builder.append(listener);

        builder.append("]");

        return builder.toString();
    }

}
