/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyRegisterPortWithElasticLoadBalancerリクエストクラス。<br />
 * このクラスはNiftyRegisterPortWithElasticLoadBalancerへのリクエストを構築します。
 *
 */
@Action("NiftyRegisterPortWithElasticLoadBalancer")
public class NiftyRegisterPortWithElasticLoadBalancerRequest implements Request {

    /** マルチロードバランサーユニークID */
    private String elasticLoadBalancerId;

    /** マルチロードバランサー名 */
    private String elasticLoadBalancerName;

    /** リスナー情報 */
    private RequestListener listener;

    /**
     * マルチロードバランサーユニークIDを取得します。
     * 
     * @return マルチロードバランサーユニークID
     */
    @Query(name = "ElasticLoadBalancerId")
    public String getElasticLoadBalancerId() {
        return elasticLoadBalancerId;
    }

    /**
     * マルチロードバランサーユニークIDを設定します。
     * 
     * @param elasticLoadBalancerId
     *            マルチロードバランサーユニークID
     */
    public void setElasticLoadBalancerId(String elasticLoadBalancerId) {
        this.elasticLoadBalancerId = elasticLoadBalancerId;
    }

    /**
     * マルチロードバランサーユニークIDを設定し、自オブジェクトを返します。
     * 
     * @param elasticLoadBalancerId
     *            マルチロードバランサーユニークID
     * @return 自オブジェクト
     */
    public NiftyRegisterPortWithElasticLoadBalancerRequest
        withElasticLoadBalancerId(String elasticLoadBalancerId) {
        setElasticLoadBalancerId(elasticLoadBalancerId);
        return this;
    }

    /**
     * マルチロードバランサー名を取得します。
     * 
     * @return マルチロードバランサー名
     */
    @Query(name = "ElasticLoadBalancerName")
    public String getElasticLoadBalancerName() {
        return elasticLoadBalancerName;
    }

    /**
     * マルチロードバランサー名を設定します。
     * 
     * @param elasticLoadBalancerName
     *            マルチロードバランサー名
     */
    public void setElasticLoadBalancerName(String elasticLoadBalancerName) {
        this.elasticLoadBalancerName = elasticLoadBalancerName;
    }

    /**
     * マルチロードバランサー名を設定し、自オブジェクトを返します。
     * 
     * @param elasticLoadBalancerName
     *            マルチロードバランサー名
     * @return 自オブジェクト
     */
    public NiftyRegisterPortWithElasticLoadBalancerRequest
        withElasticLoadBalancerName(String elasticLoadBalancerName) {
        setElasticLoadBalancerName(elasticLoadBalancerName);
        return this;
    }

    /**
     * リスナー情報を取得します。
     * 
     * @return リスナー情報
     */
    @Query(name = "Listeners")
    public RequestListener getListener() {
        return listener;
    }

    /**
     * リスナー情報を設定します。
     * 
     * @param listener
     *            リスナー情報
     */
    public void setListener(RequestListener listener) {
        this.listener = listener;
    }

    /**
     * リスナー情報を設定し、自オブジェクトを返します。
     * 
     * @param listener
     *            リスナー情報
     * @return 自オブジェクト
     */
    public NiftyRegisterPortWithElasticLoadBalancerRequest withListener(RequestListener listener) {
        setListener(listener);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[elasticLoadBalancerId=");
        builder.append(elasticLoadBalancerId);
        builder.append(", elasticLoadBalancerName=");
        builder.append(elasticLoadBalancerName);
        builder.append(", listener=");
        builder.append(listener);

        builder.append("]");

        return builder.toString();
    }

}
