/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model;

import com.nifty.cloud.sdk.Result;
import com.nifty.cloud.sdk.annotation.Xml2Response;
import com.nifty.cloud.sdk.multiloadbalancer.model.transform.ElasticLoadBalancerDescriptionsConverter;
import com.nifty.cloud.sdk.multiloadbalancer.model.transform.NiftyDescribeElasticLoadBalancersResponse;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;

/**
 * NiftyDescribeElasticLoadBalancers結果処理クラス。<br />
 * このクラスはNiftyDescribeElasticLoadBalancersのレスポンスを格納します。
 */
@Xml2Response(response = NiftyDescribeElasticLoadBalancersResponse.class)
public class NiftyDescribeElasticLoadBalancersResult extends Result {

    /** マルチロードバランサーの情報 */
    @XStreamAlias("ElasticLoadBalancerDescriptions")
    @XStreamConverter(ElasticLoadBalancerDescriptionsConverter.class)
    private ElasticLoadBalancerDescriptions elasticLoadBalancerDescriptions;

    /**
     * マルチロードバランサーの情報を取得します。
     * 
     * @return マルチロードバランサーの情報
     */
    public ElasticLoadBalancerDescriptions getElasticLoadBalancerDescriptions() {
        return elasticLoadBalancerDescriptions;
    }

    /**
     * マルチロードバランサーの情報を設定します。
     * 
     * @param elasticLoadBalancerDescriptions
     *            マルチロードバランサーの情報
     */
    public void setElasticLoadBalancerDescriptions(
        ElasticLoadBalancerDescriptions elasticLoadBalancerDescriptions) {
        this.elasticLoadBalancerDescriptions = elasticLoadBalancerDescriptions;
    }

    /**
     * マルチロードバランサーの情報を設定し、自オブジェクトを返します。
     * 
     * @param elasticLoadBalancerDescriptions
     *            マルチロードバランサーの情報
     * @return 自オブジェクト
     */
    public NiftyDescribeElasticLoadBalancersResult withElasticLoadBalancerDescriptions(
        ElasticLoadBalancerDescriptions elasticLoadBalancerDescriptions) {
        setElasticLoadBalancerDescriptions(elasticLoadBalancerDescriptions);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[elasticLoadBalancerDescriptions=");
        builder.append(elasticLoadBalancerDescriptions);

        builder.append("]");

        return builder.toString();
    }

}
