/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyDescribeElasticLoadBalancersリクエストクラス。<br />
 * このクラスはNiftyDescribeElasticLoadBalancersへのリクエストを構築します。
 *
 */
@Action("NiftyDescribeElasticLoadBalancers")
public class NiftyDescribeElasticLoadBalancersRequest implements Request {

    /** マルチロードバランサーリスト */
    private ElasticLoadBalancers elasticLoadBalancers;

    /** フィルター */
    private List<Filter> filters;

    /**
     * マルチロードバランサーリストを取得します。
     * 
     * @return マルチロードバランサーリスト
     */
    @Query(name = "ElasticLoadBalancers")
    public ElasticLoadBalancers getElasticLoadBalancers() {
        return elasticLoadBalancers;
    }

    /**
     * マルチロードバランサーリストを設定します。
     * 
     * @param elasticLoadBalancers
     *            マルチロードバランサーリスト
     */
    public void setElasticLoadBalancers(ElasticLoadBalancers elasticLoadBalancers) {
        this.elasticLoadBalancers = elasticLoadBalancers;
    }

    /**
     * マルチロードバランサーリストを設定し、自オブジェクトを返します。
     * 
     * @param elasticLoadBalancers
     *            マルチロードバランサーリスト
     * @return 自オブジェクト
     */
    public NiftyDescribeElasticLoadBalancersRequest
        withElasticLoadBalancers(ElasticLoadBalancers elasticLoadBalancers) {
        setElasticLoadBalancers(elasticLoadBalancers);
        return this;
    }

    /**
     * フィルターを取得します。
     * 
     * @return フィルター
     */
    @Query(name = "Filter")
    public List<Filter> getFilter() {
        return filters;
    }

    /**
     * フィルターを設定します。
     * 
     * @param filters
     *            フィルター
     */
    public void setFilter(List<Filter> filters) {
        this.filters = filters;
    }

    /**
     * フィルターのリストを設定し、自オブジェクトを返します。
     * 
     * @param filters
     *            フィルターのリスト
     * @return 自オブジェクト
     */
    public NiftyDescribeElasticLoadBalancersRequest withFilter(Collection<Filter> filters) {

        if (this.filters == null) {
            this.filters = new ArrayList<Filter>();
        }

        if (filters != null && !filters.isEmpty()) {
            getFilter().addAll(filters);
        }

        return this;
    }

    /**
     * フィルターの配列を設定し、自オブジェクトを返します。
     * 
     * @param filter
     *            フィルター
     * @return 自オブジェクト
     */
    public NiftyDescribeElasticLoadBalancersRequest withFilter(Filter... filter) {

        if (this.filters == null) {
            this.filters = new ArrayList<Filter>();
        }

        if (filter != null && filter.length > 0) {

            for (Filter work : filter) {
                getFilter().add(work);
            }

        }

        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[elasticLoadBalancers=");
        builder.append(elasticLoadBalancers);

        builder.append(", filters=");
        builder.append(filters);

        builder.append("]");

        return builder.toString();
    }

}
