/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model;

import com.nifty.cloud.sdk.Result;
import com.nifty.cloud.sdk.annotation.Xml2Response;
import com.nifty.cloud.sdk.multiloadbalancer.model.transform.NiftyDeregisterInstancesFromElasticLoadBalancerResponse;
import com.nifty.cloud.sdk.multiloadbalancer.model.transform.InstancesConverter;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;

/**
 * NiftyDeregisterInstancesFromElasticLoadBalancer結果処理クラス。<br />
 * このクラスはNiftyDeregisterInstancesFromElasticLoadBalancerのレスポンスを格納します。
 */
@Xml2Response(response = NiftyDeregisterInstancesFromElasticLoadBalancerResponse.class)
public class NiftyDeregisterInstancesFromElasticLoadBalancerResult extends Result {

    /** サーバー情報 */
    @XStreamAlias("Instances")
    @XStreamConverter(InstancesConverter.class)
    private ResultInstance instance;

    /**
     * サーバー情報を取得します。
     * 
     * @return サーバー情報
     */
    public ResultInstance getInstance() {
        return instance;
    }

    /**
     * サーバー情報を設定します。
     * 
     * @param instance
     *            サーバー情報
     */
    public void setInstance(ResultInstance instance) {
        this.instance = instance;
    }

    /**
     * サーバー情報を設定し、自オブジェクトを返します。
     * 
     * @param instance
     *            サーバー情報
     * @return 自オブジェクト
     */
    public NiftyDeregisterInstancesFromElasticLoadBalancerResult
        withInstance(ResultInstance instance) {
        setInstance(instance);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[instance=");
        builder.append(instance);

        builder.append("]");

        return builder.toString();

    }

}
