/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model;

import com.nifty.cloud.sdk.Result;
import com.nifty.cloud.sdk.annotation.Xml2Response;
import com.nifty.cloud.sdk.multiloadbalancer.model.transform.NiftyCreateElasticLoadBalancerResponse;
import com.thoughtworks.xstream.annotations.XStreamAlias;

/**
 * NiftyCreateElasticLoadBalancer結果処理クラス。<br />
 * このクラスはNiftyCreateElasticLoadBalancerのレスポンスを格納します。
 */
@Xml2Response(response = NiftyCreateElasticLoadBalancerResponse.class)
public class NiftyCreateElasticLoadBalancerResult extends Result {

    /** VIPネットワークIPアドレス */
    @XStreamAlias("DNSName")
    private String dnsName;

    /**
     * VIPネットワークIPアドレスを取得します。
     * 
     * @return VIPネットワークIPアドレス
     */
    public String getDnsName() {
        return dnsName;
    }

    /**
     * VIPネットワークIPアドレスを設定します。
     * 
     * @param dnsName
     *            VIPネットワークIPアドレス
     */
    public void setDnsName(String dnsName) {
        this.dnsName = dnsName;
    }

    /**
     * VIPネットワークIPアドレスを設定し、自オブジェクトを返します。
     * 
     * @param dnsName
     *            VIPネットワークIPアドレス
     * @return 自オブジェクト
     */
    public NiftyCreateElasticLoadBalancerResult withDnsName(String dnsName) {
        setDnsName(dnsName);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[dnsName=");
        builder.append(dnsName);

        builder.append("]");

        return builder.toString();
    }

}
