/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyCreateElasticLoadBalancerリクエストクラス。<br />
 * このクラスはNiftyCreateElasticLoadBalancerへのリクエストを構築します。
 *
 */
@Action("NiftyCreateElasticLoadBalancer")
public class NiftyCreateElasticLoadBalancerRequest implements Request {

    /** マルチロードバランサー名 */
    private String elasticLoadBalancerName;

    /** リスナー情報リスト */
    private RequestListenerCreate requestListenerCreate;

    /** ゾーン情報 */
    private AvailabilityZones availabilityZones;

    /** 最大ネットワーク流量 */
    private Integer networkVolume;

    /** 利用料金タイプ */
    private String accountingType;

    /** ネットワークインタフェースリスト */
    private List<NetworkInterface> networkInterfaceList;

    /**
     * マルチロードバランサー名を取得します。
     * 
     * @return マルチロードバランサー名
     */
    @Query(name = "ElasticLoadBalancerName")
    public String getElasticLoadBalancerName() {
        return elasticLoadBalancerName;
    }

    /**
     * マルチロードバランサー名を設定します。
     * 
     * @param elasticLoadBalancerName
     *            マルチロードバランサー名
     */
    public void setElasticLoadBalancerName(String elasticLoadBalancerName) {
        this.elasticLoadBalancerName = elasticLoadBalancerName;
    }

    /**
     * マルチロードバランサー名を設定し、自オブジェクトを返します。
     * 
     * @param elasticLoadBalancerName
     *            マルチロードバランサー名
     * @return 自オブジェクト
     */
    public NiftyCreateElasticLoadBalancerRequest
        withElasticLoadBalancerName(String elasticLoadBalancerName) {
        setElasticLoadBalancerName(elasticLoadBalancerName);
        return this;
    }

    /**
     * リスナー情報リストを取得します。
     * 
     * @return リスナー情報リスト
     */
    @Query(name = "Listeners")
    public RequestListenerCreate getRequestListenerCreate() {
        return requestListenerCreate;
    }

    /**
     * リスナー情報リストを設定します。
     * 
     * @param requestListenerCreate
     *            リスナー情報リスト
     */
    public void setRequestListenerCreate(RequestListenerCreate requestListenerCreate) {
        this.requestListenerCreate = requestListenerCreate;
    }

    /**
     * リスナー情報リストを設定し、自オブジェクトを返します。
     * 
     * @param requestListenerCreate
     *            リスナー情報リスト
     * @return 自オブジェクト
     */
    public NiftyCreateElasticLoadBalancerRequest
        withRequestListenerCreate(RequestListenerCreate requestListenerCreate) {
        setRequestListenerCreate(requestListenerCreate);
        return this;
    }

    /**
     * ゾーン情報を取得します。
     * 
     * @return ゾーン情報
     */
    @Query(name = "AvailabilityZones")
    public AvailabilityZones getAvailabilityZones() {
        return availabilityZones;
    }

    /**
     * ゾーン情報を設定します。
     * 
     * @param availabilityZones
     *            ゾーン情報
     */
    public void setAvailabilityZones(AvailabilityZones availabilityZones) {
        this.availabilityZones = availabilityZones;
    }

    /**
     * ゾーン情報を設定し、自オブジェクトを返します。
     * 
     * @param availabilityZones
     *            ゾーン情報
     * @return 自オブジェクト
     */
    public NiftyCreateElasticLoadBalancerRequest
        withAvailabilityZones(AvailabilityZones availabilityZones) {
        setAvailabilityZones(availabilityZones);
        return this;
    }

    /**
     * 最大ネットワーク流量を取得します。
     * 
     * @return 最大ネットワーク流量
     */
    @Query(name = "NetworkVolume")
    public Integer getNetworkVolume() {
        return networkVolume;
    }

    /**
     * 最大ネットワーク流量を設定します。
     * 
     * @param networkVolume
     *            最大ネットワーク流量
     */
    public void setNetworkVolume(Integer networkVolume) {
        this.networkVolume = networkVolume;
    }

    /**
     * 最大ネットワーク流量を設定し、自オブジェクトを返します。
     * 
     * @param networkVolume
     *            最大ネットワーク流量
     * @return 自オブジェクト
     */
    public NiftyCreateElasticLoadBalancerRequest withNetworkVolume(Integer networkVolume) {
        setNetworkVolume(networkVolume);
        return this;
    }

    /**
     * 利用料金タイプを取得します。
     * 
     * @return 利用料金タイプ
     */
    @Query(name = "AccountingType")
    public String getAccountingType() {
        return accountingType;
    }

    /**
     * 利用料金タイプを設定します。
     * 
     * @param accountingType
     *            利用料金タイプ
     */
    public void setAccountingType(String accountingType) {
        this.accountingType = accountingType;
    }

    /**
     * 利用料金タイプを設定し、自オブジェクトを返します。
     * 
     * @param accountingType
     *            利用料金タイプ
     * @return 自オブジェクト
     */
    public NiftyCreateElasticLoadBalancerRequest withAccountingType(String accountingType) {
        setAccountingType(accountingType);
        return this;
    }

    /**
     * ネットワークインタフェースリストを取得します。
     * 
     * @return ネットワークインタフェースリスト
     */
    @Query(name = "NetworkInterface")
    public List<NetworkInterface> getNetworkInterfaceList() {
        return networkInterfaceList;
    }

    /**
     * ネットワークインタフェースリストを設定します。
     * 
     * @param networkInterfaceList
     *            ネットワークインタフェースリスト
     */
    public void setNetworkInterfaceList(List<NetworkInterface> networkInterfaceList) {
        this.networkInterfaceList = networkInterfaceList;
    }

    /**
     * ネットワークインタフェースリストを設定し、自オブジェクトを返します。
     * 
     * @param networkInterfaceList
     *            ネットワークインタフェースリスト
     * @return 自オブジェクト
     */
    public NiftyCreateElasticLoadBalancerRequest
        withNetworkInterfaceList(Collection<NetworkInterface> networkInterfaceList) {

        if (this.networkInterfaceList == null) {
            this.networkInterfaceList = new ArrayList<NetworkInterface>();
        }

        if (networkInterfaceList != null && !networkInterfaceList.isEmpty()) {
            getNetworkInterfaceList().addAll(networkInterfaceList);
        }

        return this;
    }

    /**
     * ネットワークインタフェースの配列を設定し、自オブジェクトを返します。
     * 
     * @param networkInterface
     *            ネットワークインタフェースの配列
     * @return 自オブジェクト
     */
    public NiftyCreateElasticLoadBalancerRequest
        withNetworkInterfaceList(NetworkInterface... networkInterface) {

        if (this.networkInterfaceList == null) {
            this.networkInterfaceList = new ArrayList<NetworkInterface>();
        }

        if (networkInterface != null && networkInterface.length > 0) {

            for (NetworkInterface work : networkInterface) {
                getNetworkInterfaceList().add(work);
            }

        }

        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[elasticLoadBalancerName=");
        builder.append(elasticLoadBalancerName);
        builder.append(", requestListenerCreate=");
        builder.append(requestListenerCreate);
        builder.append(", availabilityZones=");
        builder.append(availabilityZones);
        builder.append(", networkVolume=");
        builder.append(networkVolume);
        builder.append(", accountingType=");
        builder.append(accountingType);
        builder.append(", networkInterfaceList=");
        builder.append(networkInterfaceList);

        builder.append("]");

        return builder.toString();
    }

}
