/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model;

import com.nifty.cloud.sdk.Result;
import com.nifty.cloud.sdk.annotation.Xml2Response;
import com.nifty.cloud.sdk.multiloadbalancer.model.transform.NiftyConfigureElasticLoadBalancerHealthCheckResponse;
import com.thoughtworks.xstream.annotations.XStreamAlias;

/**
 * NiftyConfigureElasticLoadBalancerHealthCheck結果処理クラス。<br />
 * このクラスはNiftyConfigureElasticLoadBalancerHealthCheckのレスポンスを格納します。
 */
@Xml2Response(response = NiftyConfigureElasticLoadBalancerHealthCheckResponse.class)
public class NiftyConfigureElasticLoadBalancerHealthCheckResult extends Result {

    /** ヘルスチェック情報 */
    @XStreamAlias("HealthCheck")
    private ResponseHealthCheck healthCheck;

    /**
     * ヘルスチェック情報を取得します。
     * 
     * @return ヘルスチェック情報
     */
    public ResponseHealthCheck getHealthCheck() {
        return healthCheck;
    }

    /**
     * ヘルスチェック情報を設定します。
     * 
     * @param healthCheck
     *            ヘルスチェック情報
     */
    public void setHealthCheck(ResponseHealthCheck healthCheck) {
        this.healthCheck = healthCheck;
    }

    /**
     * ヘルスチェック情報を設定し、自オブジェクトを返します。
     * 
     * @param healthCheck
     *            ヘルスチェック情報
     * @return 自オブジェクト
     */
    public NiftyConfigureElasticLoadBalancerHealthCheckResult
        withHealthCheck(ResponseHealthCheck healthCheck) {
        setHealthCheck(healthCheck);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[healthCheck=");
        builder.append(healthCheck);

        builder.append("]");

        return builder.toString();
    }

}
