/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyConfigureElasticLoadBalancerHealthCheckリクエストクラス。<br />
 * このクラスはNiftyConfigureElasticLoadBalancerHealthCheckへのリクエストを構築します。
 *
 */
@Action("NiftyConfigureElasticLoadBalancerHealthCheck")
public class NiftyConfigureElasticLoadBalancerHealthCheckRequest implements Request {

    /** 対象のマルチロードバランサーユニークID */
    private String elasticLoadBalancerId;

    /** 対象のマルチロードバランサー名 */
    private String elasticLoadBalancerName;

    /** プロトコル */
    private String protocol;

    /** 待ち受けポート */
    private Integer elasticLoadBalancerPort;

    /** 宛先ポート */
    private Integer instancePort;

    /** ヘルスチェック情報 */
    private RequestHealthCheck healthCheck;

    /**
     * 対象のマルチロードバランサーユニークIDを取得します。
     * 
     * @return 対象のマルチロードバランサーユニークID
     */
    @Query(name = "ElasticLoadBalancerId")
    public String getElasticLoadBalancerId() {
        return elasticLoadBalancerId;
    }

    /**
     * 対象のマルチロードバランサーユニークIDを設定します。
     * 
     * @param elasticLoadBalancerId
     *            対象のマルチロードバランサーユニークID
     */
    public void setElasticLoadBalancerId(String elasticLoadBalancerId) {
        this.elasticLoadBalancerId = elasticLoadBalancerId;
    }

    /**
     * 対象のマルチロードバランサーユニークIDを設定し、自オブジェクトを返します。
     * 
     * @param elasticLoadBalancerId
     *            マルチロードバランサーユニークID
     * @return 自オブジェクト
     */
    public NiftyConfigureElasticLoadBalancerHealthCheckRequest
        withElasticLoadBalancerId(String elasticLoadBalancerId) {
        setElasticLoadBalancerId(elasticLoadBalancerId);
        return this;
    }

    /**
     * 対象のマルチロードバランサー名を取得します。
     * 
     * @return 対象のマルチロードバランサー名
     */
    @Query(name = "ElasticLoadBalancerName")
    public String getElasticLoadBalancerName() {
        return elasticLoadBalancerName;
    }

    /**
     * 対象のマルチロードバランサー名を設定します。
     * 
     * @param elasticLoadBalancerName
     *            対象のマルチロードバランサー名
     */
    public void setElasticLoadBalancerName(String elasticLoadBalancerName) {
        this.elasticLoadBalancerName = elasticLoadBalancerName;
    }

    /**
     * 対象のマルチロードバランサー名を設定し、自オブジェクトを返します。
     * 
     * @param elasticLoadBalancerName
     *            対象のマルチロードバランサー名
     * @return 自オブジェクト
     */
    public NiftyConfigureElasticLoadBalancerHealthCheckRequest
        withElasticLoadBalancerName(String elasticLoadBalancerName) {
        setElasticLoadBalancerName(elasticLoadBalancerName);
        return this;
    }

    /**
     * プロトコルを取得します。
     * 
     * @return プロトコル
     */
    @Query(name = "Protocol", require = true)
    public String getProtocol() {
        return protocol;
    }

    /**
     * プロトコルを設定します。
     * 
     * @param protocol
     *            プロトコル
     */
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    /**
     * プロトコルを設定し、自オブジェクトを返します。
     * 
     * @param protocol
     *            プロトコル
     * @return 自オブジェクト
     */
    public NiftyConfigureElasticLoadBalancerHealthCheckRequest withProtocol(String protocol) {
        setProtocol(protocol);
        return this;
    }

    /**
     * 待ち受けポートを取得します。
     * 
     * @return 待ち受けポート
     */
    @Query(name = "ElasticLoadBalancerPort", require = true)
    public Integer getElasticLoadBalancerPort() {
        return elasticLoadBalancerPort;
    }

    /**
     * 待ち受けポートを設定します。
     * 
     * @param elasticLoadBalancerPort
     *            待ち受けポート
     */
    public void setElasticLoadBalancerPort(Integer elasticLoadBalancerPort) {
        this.elasticLoadBalancerPort = elasticLoadBalancerPort;
    }

    /**
     * 待ち受けポートを設定し、自オブジェクトを返します。
     * 
     * @param elasticLoadBalancerPort
     *            待ち受けポート
     * @return 自オブジェクト
     */
    public NiftyConfigureElasticLoadBalancerHealthCheckRequest
        withElasticLoadBalancerPort(Integer elasticLoadBalancerPort) {
        setElasticLoadBalancerPort(elasticLoadBalancerPort);
        return this;
    }

    /**
     * 宛先ポートを取得します。
     * 
     * @return 宛先ポート
     */
    @Query(name = "InstancePort", require = true)
    public Integer getInstancePort() {
        return instancePort;
    }

    /**
     * 宛先ポートを設定します。
     * 
     * @param instancePort
     *            宛先ポート
     */
    public void setInstancePort(Integer instancePort) {
        this.instancePort = instancePort;
    }

    /**
     * 宛先ポートを設定し、自オブジェクトを返します。
     * 
     * @param instancePort
     *            宛先ポート
     * @return 自オブジェクト
     */
    public NiftyConfigureElasticLoadBalancerHealthCheckRequest
        withInstancePort(Integer instancePort) {
        setInstancePort(instancePort);
        return this;
    }

    /**
     * ヘルスチェック情報を取得します。
     * 
     * @return ヘルスチェック情報
     */
    @Query(name = "HealthCheck")
    public RequestHealthCheck getHealthCheck() {
        return healthCheck;
    }

    /**
     * ヘルスチェック情報を設定します。
     * 
     * @param healthCheck
     *            ヘルスチェック情報
     */
    public void setHealthCheck(RequestHealthCheck healthCheck) {
        this.healthCheck = healthCheck;
    }

    /**
     * ヘルスチェック情報を設定し、自オブジェクトを返します。
     * 
     * @param healthCheck
     *            ヘルスチェック情報
     * @return 自オブジェクト
     */
    public NiftyConfigureElasticLoadBalancerHealthCheckRequest
        withHealthCheck(RequestHealthCheck healthCheck) {
        setHealthCheck(healthCheck);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[elasticLoadBalancerId=");
        builder.append(elasticLoadBalancerId);

        builder.append(", elasticLoadBalancerName=");
        builder.append(elasticLoadBalancerName);

        builder.append(", protocol=");
        builder.append(protocol);

        builder.append(", elasticLoadBalancerPort=");
        builder.append(elasticLoadBalancerPort);

        builder.append(", instancePort=");
        builder.append(instancePort);

        builder.append(", healthCheck=");
        builder.append(healthCheck);

        builder.append("]");

        return builder.toString();
    }

}
