/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.annotation.Query;

/**
 * ネットワークインタフェースクラス。<br />
 * このクラスはネットワークインタフェースを保持します。
 *
 */
public class NetworkInterface {

    /** ネットワークID */
    private String networkId;

    /** ネットワーク名 */
    private String networkName;

    /** IPアドレス */
    private String ipAddress;

    /** デバイス番号 */
    private Integer deviceIndex;

    /** VIPネットワークフラグ */
    private Boolean isVipNetwork;

    /** メモ情報 */
    private String description;

    /** システムIPアドレスリスト. */
    private List<SystemIpAddress> systemIpAddresses;

    /**
     * ネットワークIDを取得します。
     *
     * @return ネットワークID
     */
    @Query(name = "NetworkId")
    public String getNetworkId() {
        return networkId;
    }

    /**
     * ネットワークIDを設定します。
     *
     * @param networkId
     *            ネットワークID
     */
    public void setNetworkId(String networkId) {
        this.networkId = networkId;
    }

    /**
     * ネットワークIDを設定し、自オブジェクトを返します。
     *
     * @param networkId
     *            ネットワークID
     * @return 自オブジェクト
     */
    public NetworkInterface withNetworkId(String networkId) {
        setNetworkId(networkId);
        return this;
    }

    /**
     * ネットワーク名を取得します。
     *
     * @return ネットワーク名
     */
    @Query(name = "NetworkName")
    public String getNetworkName() {
        return networkName;
    }

    /**
     * ネットワーク名を設定します。
     *
     * @param networkName
     *            ネットワーク名
     */
    public void setNetworkName(String networkName) {
        this.networkName = networkName;
    }

    /**
     * ネットワーク名を設定し、自オブジェクトを返します。
     *
     * @param networkName
     *            ネットワーク名
     * @return 自オブジェクト
     */
    public NetworkInterface withNetworkName(String networkName) {
        setNetworkName(networkName);
        return this;
    }

    /**
     * IPアドレスを取得します。
     *
     * @return IPアドレス
     */
    @Query(name = "IpAddress")
    public String getIpAddress() {
        return ipAddress;
    }

    /**
     * IPアドレスを設定します。
     *
     * @param ipAddress
     *            IPアドレス
     */
    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    /**
     * IPアドレスを設定し、自オブジェクトを返します。
     *
     * @param ipAddress
     *            IPアドレス
     * @return
     */
    public NetworkInterface withIpAddress(String ipAddress) {
        setIpAddress(ipAddress);
        return this;
    }

    /**
     * VIPネットワークフラグを取得します。
     *
     * @return VIPネットワークフラグ
     */
    @Query(name = "IsVipNetwork")
    public Boolean getIsVipNetwork() {
        return isVipNetwork;
    }

    /**
     * VIPネットワークフラグを設定します。
     *
     * @param isVipNetwork
     *            VIPネットワークフラグ
     */
    public void setIsVipNetwork(Boolean isVipNetwork) {
        this.isVipNetwork = isVipNetwork;
    }

    /**
     * VIPネットワークフラグを設定し、自オブジェクトを返します。
     *
     * @param isVipNetwork
     *            VIPネットワークフラグ
     * @return 自オブジェクト
     */
    public NetworkInterface withIsVipNetwork(Boolean isVipNetwork) {
        setIsVipNetwork(isVipNetwork);
        return this;
    }

    /**
     * デバイス番号を取得します。
     *
     * @return デバイス番号
     */
    public Integer getDeviceIndex() {
        return deviceIndex;
    }

    /**
     * デバイス番号を設定します。
     *
     * @param deviceIndex
     *            デバイス番号
     */
    public void setDeviceIndex(Integer deviceIndex) {
        this.deviceIndex = deviceIndex;
    }

    /**
     * デバイス番号を設定し、自オブジェクトを返します。
     *
     * @param deviceIndex
     *            デバイス番号
     * @return 自オブジェクト
     */
    public NetworkInterface withDeviceIndex(Integer deviceIndex) {
        setDeviceIndex(deviceIndex);
        return this;
    }

    /**
     * メモ情報を取得します。
     *
     * @return メモ情報
     */
    public String getDescription() {
        return description;
    }

    /**
     * メモ情報を設定します。
     *
     * @param description
     *            メモ情報
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * メモ情報を設定し、自オブジェクトを返します。
     *
     * @param description
     *            メモ情報
     * @return 自オブジェクト
     */
    public NetworkInterface withDescription(String description) {
        setDescription(description);
        return this;
    }

    /**
     * システムIPアドレスリストを取得します.
     *
     * @return システムIPアドレスリスト
     */
    @Query(name = "SystemIpAddresses")
    public List<SystemIpAddress> getSystemIpAddresses() {
        return systemIpAddresses;
    }

    /**
     * システムIPアドレスリストを設定します.
     *
     * @param systemIpAddresses
     *            システムIPアドレスリスト
     */
    public void setSystemIpAddresses(List<SystemIpAddress> systemIpAddresses) {
        this.systemIpAddresses = systemIpAddresses;
    }

    /**
     * システムIPアドレスリストを設定し、自オブジェクトを返します。
     *
     * @param systemIpAddresses
     *            システムIPアドレスリスト
     * @return 自オブジェクト
     */
    public NetworkInterface withSystemIpAddresses(Collection<SystemIpAddress> systemIpAddresses) {

        if (this.systemIpAddresses == null) {
            this.systemIpAddresses = new ArrayList<SystemIpAddress>();
        }

        if (systemIpAddresses != null && !systemIpAddresses.isEmpty()) {
            getSystemIpAddresses().addAll(systemIpAddresses);
        }

        return this;
    }

    /**
     * システムIPアドレスの配列を設定し、自オブジェクトを返します.
     *
     * @param systemIpAddress
     *            システムIPアドレスの配列
     */
    public NetworkInterface withSystemIpAddresses(SystemIpAddress... systemIpAddresses) {

        if (this.systemIpAddresses == null) {
            this.systemIpAddresses = new ArrayList<SystemIpAddress>();
        }

        if (systemIpAddresses != null && systemIpAddresses.length > 0) {

            for (SystemIpAddress work: systemIpAddresses) {
                getSystemIpAddresses().add(work);
            }
        }

        return this;
    }

    /*
     * (non-Javadoc)
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[networkId=");
        builder.append(networkId);
        builder.append("networkName=");
        builder.append(networkName);
        builder.append("ipAddress=");
        builder.append(ipAddress);
        builder.append("isVipNetwork=");
        builder.append(isVipNetwork);
        builder.append("deviceIndex=");
        builder.append(deviceIndex);
        builder.append("description=");
        builder.append(description);
        builder.append("systemIpAddresses=");
        builder.append(systemIpAddresses);

        builder.append("]");

        return builder.toString();

    }

}
