/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model;

import com.nifty.cloud.sdk.annotation.Query;

/**
 * ロードバランサー属性クラス。<br />
 * このクラスはロードバランサーの属性を保持します。
 *
 */
public class LoadBalancerAttribute {

    /** セッション情報 */
    private Session session;

    /** Sorryページ設定 */
    private SorryPage sorryPage;

    /** 更新対象項目 */
    private AdditionalAttributes additionalAttributes;

    /**
     * セッション情報を取得します。
     * 
     * @return セッション情報
     */
    @Query(name = "Session")
    public Session getSession() {
        return session;
    }

    /**
     * セッション情報を設定します。
     * 
     * @param session
     *            セッション情報
     */
    public void setSession(Session session) {
        this.session = session;
    }

    /**
     * セッション情報を設定し、自オブジェクトを返します。
     * 
     * @param session
     *            セッション情報
     * @return 自オブジェクト
     */
    public LoadBalancerAttribute withSession(Session session) {
        setSession(session);
        return this;
    }

    /**
     * Sorryページ設定を取得します。
     * 
     * @return Sorryページ設定
     */
    @Query(name = "SorryPage")
    public SorryPage getSorryPage() {
        return sorryPage;
    }

    /**
     * Sorryページ設定を設定します。
     * 
     * @param sorryPage
     *            Sorryページ設定
     */
    public void setSorryPage(SorryPage sorryPage) {
        this.sorryPage = sorryPage;
    }

    /**
     * Sorryページ設定を設定し、自オブジェクトを返します。
     * 
     * @param sorryPage
     *            Sorryページ設定
     * @return 自オブジェクト
     */
    public LoadBalancerAttribute withSorryPage(SorryPage sorryPage) {
        setSorryPage(sorryPage);
        return this;
    }

    /**
     * 更新対象項目を取得します。
     * 
     * @return 更新対象項目
     */
    @Query(name = "AdditionalAttributes")
    public AdditionalAttributes getAdditionalAttributes() {
        return additionalAttributes;
    }

    /**
     * 更新対象項目を設定します。
     * 
     * @param additionalAttributes
     *            更新対象項目
     */
    public void setAdditionalAttributes(AdditionalAttributes additionalAttributes) {
        this.additionalAttributes = additionalAttributes;
    }

    /**
     * 更新対象項目を設定し、自オブジェクトを返します。
     * 
     * @param additionalAttributes
     *            更新対象項目
     * @return 自オブジェクト
     */
    public LoadBalancerAttribute
        withAdditionalAttributes(AdditionalAttributes additionalAttributes) {
        setAdditionalAttributes(additionalAttributes);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[session=");
        builder.append(session);
        builder.append(", sorryPage=");
        builder.append(sorryPage);
        builder.append(", additionalAttributes=");
        builder.append(additionalAttributes);

        builder.append("]");

        return builder.toString();
    }

}
