/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model;

/**
 * ListenerDescribeクラス。<br />
 * このクラスはDescribe時のポート情報を保持します。
 *
 */
public class ListenerDescribe {

    /** プロトコル */
    private String protocol;

    /** 待ち受けポート */
    private Integer elasticLoadBalancerPort;

    /** 宛先ポート */
    private Integer instancePort;

    /** ロードバランス方式 */
    private String balancingType;

    /** メモ情報 */
    private String description;

    /** SSL証明書の発行識別子 */
    private String sslCertificateId;

    /** セッション固定情報 */
    private StickinessPolicy stickinessPolicy;

    /** Sorryページ情報 */
    private SorryPage sorryPage;

    /** サーバー情報セット */
    private Instance instances;

    /** ヘルスチェック情報 */
    private HealthCheckDescribe healthCheck;

    /**
     * プロトコルを取得します。
     * 
     * @return プロトコル
     */
    public String getProtocol() {
        return protocol;
    }

    /**
     * プロトコルを設定します。
     * 
     * @param protocol
     *            プロトコル
     */
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    /**
     * プロトコルを設定し、自オブジェクトを返します。
     * 
     * @param protocol
     *            プロトコル
     * @return 自オブジェクト
     */
    public ListenerDescribe withProtocol(String protocol) {
        setProtocol(protocol);
        return this;
    }

    /**
     * 待ち受けポートを取得します。
     * 
     * @return 待ち受けポート
     */
    public Integer getElasticLoadBalancerPort() {
        return elasticLoadBalancerPort;
    }

    /**
     * 待ち受けポートを設定します。
     * 
     * @param elasticLoadBalancerPort
     *            待ち受けポート
     */
    public void setElasticLoadBalancerPort(Integer elasticLoadBalancerPort) {
        this.elasticLoadBalancerPort = elasticLoadBalancerPort;
    }

    /**
     * 待ち受けポートを設定し、自オブジェクトを返します。
     * 
     * @param elasticLoadBalancerPort
     *            待ち受けポート
     * @return 自オブジェクト
     */
    public ListenerDescribe withElasticLoadBalancerPort(Integer elasticLoadBalancerPort) {
        setElasticLoadBalancerPort(elasticLoadBalancerPort);
        return this;
    }

    /**
     * 宛先ポートを取得します。
     * 
     * @return 宛先ポート
     */
    public Integer getInstancePort() {
        return instancePort;
    }

    /**
     * 宛先ポートを設定します。
     * 
     * @param instancePort
     *            宛先ポート
     */
    public void setInstancePort(Integer instancePort) {
        this.instancePort = instancePort;
    }

    /**
     * 宛先ポートを設定し、自オブジェクトを返します。
     * 
     * @param instancePort
     *            宛先ポート
     * @return 自オブジェクト
     */
    public ListenerDescribe withInstancePort(Integer instancePort) {
        setInstancePort(instancePort);
        return this;
    }

    /**
     * ロードバランス方式を取得します。
     * 
     * @return ロードバランス方式
     */
    public String getBalancingType() {
        return balancingType;
    }

    /**
     * ロードバランス方式を設定します。
     * 
     * @param balancingType
     *            ロードバランス方式
     */
    public void setBalancingType(String balancingType) {
        this.balancingType = balancingType;
    }

    /**
     * ロードバランス方式を設定し、自オブジェクトを返します。
     * 
     * @param balancingType
     *            ロードバランス方式
     * @return 自オブジェクト
     */
    public ListenerDescribe withBalancingType(String balancingType) {
        setBalancingType(balancingType);
        return this;
    }

    /**
     * メモ情報を取得します。
     * 
     * @return メモ情報
     */
    public String getDescription() {
        return description;
    }

    /**
     * メモ情報を設定します。
     * 
     * @param description
     *            メモ情報
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * メモ情報を設定し、自オブジェクトを返します。
     * 
     * @param description
     *            メモ情報
     * @return 自オブジェクト
     */
    public ListenerDescribe withDescription(String description) {
        setDescription(description);
        return this;
    }

    /**
     * SSL証明書の発行識別子を取得します。
     * 
     * @return SSL証明書の発行識別子
     */
    public String getSslCertificateId() {
        return sslCertificateId;
    }

    /**
     * SSL証明書の発行識別子を設定します。
     * 
     * @param sslCertificateId
     *            SSL証明書の発行識別子
     */
    public void setSslCertificateId(String sslCertificateId) {
        this.sslCertificateId = sslCertificateId;
    }

    /**
     * SSL証明書の発行識別子を設定し、自オブジェクトを返します。
     * 
     * @param sslCertificateId
     *            SSL証明書の発行識別子
     * @return 自オブジェクト
     */
    public ListenerDescribe withSslCertificateId(String sslCertificateId) {
        setSslCertificateId(sslCertificateId);
        return this;
    }

    /**
     * セッション固定情報を取得します。
     * 
     * @return セッション固定情報
     */
    public StickinessPolicy getStickinessPolicy() {
        return stickinessPolicy;
    }

    /**
     * セッション固定情報を設定します。
     * 
     * @param stickinessPolicy
     *            セッション固定情報
     */
    public void setStickinessPolicy(StickinessPolicy stickinessPolicy) {
        this.stickinessPolicy = stickinessPolicy;
    }

    /**
     * セッション固定情報を設定し、自オブジェクトを返します。
     * 
     * @param stickinessPolicy
     *            セッション固定情報
     * @return 自オブジェクト
     */
    public ListenerDescribe withStickinessPolicy(StickinessPolicy stickinessPolicy) {
        setStickinessPolicy(stickinessPolicy);
        return this;
    }

    /**
     * Sorryページ情報を取得します。
     * 
     * @return Sorryページ情報
     */
    public SorryPage getSorryPage() {
        return sorryPage;
    }

    /**
     * Sorryページ情報を設定します。
     * 
     * @param sorryPage
     *            Sorryページ情報
     */
    public void setSorryPage(SorryPage sorryPage) {
        this.sorryPage = sorryPage;
    }

    /**
     * Sorryページ情報を設定し、自オブジェクトを返します。
     * 
     * @param sorryPage
     *            Sorryページ情報
     * @return 自オブジェクト
     */
    public ListenerDescribe withSorryPage(SorryPage sorryPage) {
        setSorryPage(sorryPage);
        return this;
    }

    /**
     * サーバー情報セットを取得します。
     * 
     * @return サーバー情報セット
     */
    public Instance getInstances() {
        return instances;
    }

    /**
     * サーバー情報セットを設定します。
     * 
     * @param instances
     *            サーバー情報セット
     */
    public void setInstances(Instance instances) {
        this.instances = instances;
    }

    /**
     * サーバー情報セットを設定し、自オブジェクトを返します。
     * 
     * @param instances
     *            サーバー情報セット
     * @return 自オブジェクト
     */
    public ListenerDescribe withInstances(Instance instances) {
        setInstances(instances);
        return this;
    }

    /**
     * ヘルスチェック情報を取得します。
     * 
     * @return ヘルスチェック情報
     */
    public HealthCheckDescribe getHealthCheck() {
        return healthCheck;
    }

    /**
     * ヘルスチェック情報を設定します。
     * 
     * @param healthCheck
     *            ヘルスチェック情報
     */
    public void setHealthCheck(HealthCheckDescribe healthCheck) {
        this.healthCheck = healthCheck;
    }

    /**
     * ヘルスチェック情報を設定し、自オブジェクトを返します。
     * 
     * @param healthCheck
     *            ヘルスチェック情報
     * @return 自オブジェクト
     */
    public ListenerDescribe withHealthCheck(HealthCheckDescribe healthCheck) {
        setHealthCheck(healthCheck);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[protocol=");
        builder.append(protocol);

        builder.append(", elasticLoadBalancerPort=");
        builder.append(elasticLoadBalancerPort);

        builder.append(", instancePort=");
        builder.append(instancePort);

        builder.append(", balancingType=");
        builder.append(balancingType);

        builder.append(", description=");
        builder.append(description);

        builder.append(", sslCertificateId=");
        builder.append(sslCertificateId);

        builder.append(", stickinessPolicy=");
        builder.append(stickinessPolicy);

        builder.append(", sorryPage=");
        builder.append(sorryPage);

        builder.append(", instances=");
        builder.append(instances);

        builder.append(", healthCheck=");
        builder.append(healthCheck);

        builder.append("]");

        return builder.toString();
    }

}
