/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.annotation.Query;
import com.thoughtworks.xstream.annotations.XStreamAlias;

/**
 * インスタンスクラス。<br />
 * このクラスはサーバーのメンバー情報を格納します。
 */
public class Instance {

    /** サーバー情報リスト */
    @XStreamAlias("member")
    private List<ServerMember> memberList;

    /**
     * サーバー情報リストを取得します。
     * 
     * @return サーバー情報リスト
     */
    @Query(name = "member")
    public List<ServerMember> getMemberList() {
        return memberList;
    }

    /**
     * サーバー情報リストを設定します。
     * 
     * @param memberList
     *            サーバー情報リスト
     */
    public void setMemberList(List<ServerMember> memberList) {
        this.memberList = memberList;
    }

    /**
     * サーバー情報リストを設定し、自オブジェクトを返します。
     * 
     * @param memberList
     *            サーバー情報リスト
     * @return 自オブジェクト
     */
    public Instance withMemberList(Collection<ServerMember> memberList) {

        if (this.memberList == null) {
            this.memberList = new ArrayList<ServerMember>();
        }

        if (memberList != null && !memberList.isEmpty()) {
            getMemberList().addAll(memberList);
        }

        return this;
    }

    /**
     * サーバー情報の配列を設定し、自オブジェクトを返します。
     * 
     * @param member
     *            サーバー情報の配列
     * @return 自オブジェクト
     */
    public Instance withMemberList(ServerMember... member) {

        if (this.memberList == null) {
            this.memberList = new ArrayList<ServerMember>();
        }

        if (member != null && member.length > 0) {

            for (ServerMember work : member) {
                getMemberList().add(work);
            }

        }

        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[memberList=");
        builder.append(memberList);

        builder.append("]");

        return builder.toString();

    }

}
