/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model;

import com.nifty.cloud.sdk.annotation.Query;
import com.thoughtworks.xstream.annotations.XStreamAlias;

/**
 * HttpMemberクラス。<br />
 * このクラスはヘルスチェック期待値を格納します。
 *
 */
public class HttpMember {

    /** ヘルスチェック期待値 */
    @XStreamAlias("HttpCode")
    private String httpCode;

    /**
     * ヘルスチェック期待値を取得します。
     *
     * @return ヘルスチェック期待値
     */
    @Query(name = "HttpCode")
    public String getHttpCode() {
        return httpCode;
    }

    /**
     * ヘルスチェック期待値を設定します。
     *
     * @param httpCode
     *            ヘルスチェック期待値
     */
    public void setHttpCode(String httpCode) {
        this.httpCode = httpCode;
    }

    /**
     * ヘルスチェック期待値を設定し、自オブジェクトを返します。
     *
     * @param httpCode
     *            ヘルスチェック期待値
     * @return 自オブジェクト
     */
    public HttpMember withHttpCode(String httpCode) {
        setHttpCode(httpCode);
        return this;
    }

    /*
     * (non-Javadoc)
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[httpCode=");
        builder.append(httpCode);

        builder.append("]");

        return builder.toString();
    }

}
