/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model;

import com.nifty.cloud.sdk.annotation.Query;

/**
 * ヘルスチェッククラス。<br />
 * このクラスはヘルスチェック情報を保持します。
 * 
 */
public class HealthCheckDescribe {

    /** ヘルスチェックプロトコル */
    private String target;

    /** ヘルスチェック間隔(秒) */
    private Integer interval;

    /** タイムアウト時間 */
    private Integer timeout;

    /** ヘルスチェック回数閾値 */
    private Integer unhealthyThreshold;

    /** ヘルスチェックの復旧判断 */
    private Integer healthyThreshold;

    /** ヘルスチェックパス */
    private String path;

    /** ヘルスチェック期待値 */
    private Expectation expectation;

    /** サーバー情報 */
    private Instance instance;

    /**
     * ヘルスチェックプロトコルを取得します。
     * 
     * @return ヘルスチェックプロトコル
     */
    @Query(name = "Target")
    public String getTarget() {
        return target;
    }

    /**
     * ヘルスチェックプロトコルを設定します。
     * 
     * @param target
     *            ヘルスチェックプロトコル
     */
    public void setTarget(String target) {
        this.target = target;
    }

    /**
     * ヘルスチェックプロトコルを設定し、自オブジェクトを返します。
     * 
     * @param target
     *            ヘルスチェックプロトコル
     * @return 自オブジェクト
     */
    public HealthCheckDescribe withTarget(String target) {
        setTarget(target);
        return this;
    }

    /**
     * ヘルスチェック間隔(秒)を取得します。
     * 
     * @return ヘルスチェック間隔(秒)
     */
    @Query(name = "Interval")
    public Integer getInterval() {
        return interval;
    }

    /**
     * ヘルスチェック間隔(秒)を設定します。
     * 
     * @param interval
     *            ヘルスチェック間隔(秒)
     */
    public void setInterval(Integer interval) {
        this.interval = interval;
    }

    /**
     * ヘルスチェック間隔(秒)を設定し、自オブジェクトを返します。
     * 
     * @param interval
     *            ヘルスチェック間隔(秒)
     * @return 自オブジェクト
     */
    public HealthCheckDescribe withInterval(Integer interval) {
        setInterval(interval);
        return this;
    }

    /**
     * タイムアウト時間を取得します。
     * 
     * @return タイムアウト時間
     */
    public Integer getTimeout() {
        return timeout;
    }

    /**
     * タイムアウト時間を設定します。
     * 
     * @param timeout
     *            タイムアウト時間
     */
    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    /**
     * タイムアウト時間を設定し、自オブジェクトを返します。
     * 
     * @param timeout
     *            タイムアウト時間
     * @return 自オブジェクト
     */
    public HealthCheckDescribe withTimeout(Integer timeout) {
        setTimeout(timeout);
        return this;
    }

    /**
     * ヘルスチェック回数閾値を取得します。
     * 
     * @return ヘルスチェック回数閾値
     */
    @Query(name = "UnhealthyThreshold")
    public Integer getUnhealthyThreshold() {
        return unhealthyThreshold;
    }

    /**
     * ヘルスチェック回数閾値を設定します。
     * 
     * @param unhealthyThreshold
     *            ヘルスチェック回数閾値
     */
    public void setUnhealthyThreshold(Integer unhealthyThreshold) {
        this.unhealthyThreshold = unhealthyThreshold;
    }

    /**
     * ヘルスチェック回数閾値を設定し、自オブジェクトを返します。
     * 
     * @param unhealthyThreshold
     *            ヘルスチェック回数閾値
     * @return 自オブジェクト
     */
    public HealthCheckDescribe withUnhealthyThreshold(Integer unhealthyThreshold) {
        setUnhealthyThreshold(unhealthyThreshold);
        return this;
    }

    /**
     * ヘルスチェックの復旧判断を取得します。
     * 
     * @return ヘルスチェックの復旧判断
     */
    public Integer getHealthyThreshold() {
        return healthyThreshold;
    }

    /**
     * ヘルスチェックの復旧判断を設定します。
     * 
     * @param healthyThreshold
     *            ヘルスチェックの復旧判断
     */
    public void setHealthyThreshold(Integer healthyThreshold) {
        this.healthyThreshold = healthyThreshold;
    }

    /**
     * ヘルスチェックの復旧判断を設定し、自オブジェクトを返します。
     * 
     * @param healthyThreshold ヘルスチェックの復旧判断
     * @return 自オブジェクト
     */
    public HealthCheckDescribe withHealthyThreshold(Integer healthyThreshold) {
        setHealthyThreshold(healthyThreshold);
        return this;
    }

    /**
     * ヘルスチェックパスを取得します。
     * 
     * @return ヘルスチェックパス
     */
    @Query(name = "Path")
    public String getPath() {
        return path;
    }

    /**
     * ヘルスチェックパスを設定します。
     * 
     * @param path
     *            ヘルスチェックパス
     */
    public void setPath(String path) {
        this.path = path;
    }

    /**
     * ヘルスチェックパスを設定し、自オブジェクトを返します。
     * 
     * @param path
     *            ヘルスチェックパス
     * @return 自オブジェクト
     */
    public HealthCheckDescribe withPath(String path) {
        setPath(path);
        return this;
    }

    /**
     * ヘルスチェック期待値を取得します。
     * 
     * @return ヘルスチェック期待値
     */
    @Query(name = "Expectation")
    public Expectation getExpectation() {
        return expectation;
    }

    /**
     * ヘルスチェック期待値を設定します。
     * 
     * @param expectation
     *            ヘルスチェック期待値
     */
    public void setExpectation(Expectation expectation) {
        this.expectation = expectation;
    }

    /**
     * ヘルスチェック期待値を設定し、自オブジェクトを返します。
     * 
     * @param expectation
     *            ヘルスチェック期待値
     * @return 自オブジェクト
     */
    public HealthCheckDescribe withExpectation(Expectation expectation) {
        setExpectation(expectation);
        return this;
    }

    /**
     * サーバー情報を設定します。
     * 
     * @param instance
     *            サーバー情報
     */
    public void setInstance(Instance instance) {
        this.instance = instance;
    }

    /**
     * サーバー情報を設定し、自オブジェクトを返します。
     * 
     * @param instance
     *            サーバー情報
     * @return 自オブジェクト
     */
    public HealthCheckDescribe withInstance(Instance instance) {
        setInstance(instance);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[target=");
        builder.append(target);
        builder.append(", interval=");
        builder.append(interval);
        builder.append(", timeout=");
        builder.append(timeout);
        builder.append(", unhealthyThreshold=");
        builder.append(unhealthyThreshold);
        builder.append(", healthyThreshold=");
        builder.append(healthyThreshold);
        builder.append(", path=");
        builder.append(path);
        builder.append(", expectation=");
        builder.append(expectation);
        builder.append(", instance=");
        builder.append(instance);

        builder.append("]");

        return builder.toString();
    }

    /**
     * サーバー情報を取得します。
     * 
     * @return サーバー情報
     */
    public Instance getInstance() {
        return instance;
    }

}
