/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model;

import com.nifty.cloud.sdk.annotation.Query;

/**
 * ヘルスチェッククラス。<br />
 * このクラスはヘルスチェック情報を保持します。
 * 
 */
public class HealthCheck {

    /** ヘルスチェックプロトコル */
    private String target;

    /** ヘルスチェック間隔(秒) */
    private Integer interval;

    /** ヘルスチェック回数閾値 */
    private Integer unhealthyThreshold;

    /** ヘルスチェックパス */
    private String path;

    /** ヘルスチェック期待値 */
    private Expectation expectation;

    /**
     * ヘルスチェックプロトコルを取得します。
     * 
     * @return ヘルスチェックプロトコル
     */
    @Query(name = "Target")
    public String getTarget() {
        return target;
    }

    /**
     * ヘルスチェックプロトコルを設定します。
     * 
     * @param target
     *            ヘルスチェックプロトコル
     */
    public void setTarget(String target) {
        this.target = target;
    }

    /**
     * ヘルスチェックプロトコルを設定し、自オブジェクトを返します。
     * 
     * @param target
     *            ヘルスチェックプロトコル
     * @return 自オブジェクト
     */
    public HealthCheck withTarget(String target) {
        setTarget(target);
        return this;
    }

    /**
     * ヘルスチェック間隔(秒)を取得します。
     * 
     * @return ヘルスチェック間隔(秒)
     */
    @Query(name = "Interval")
    public Integer getInterval() {
        return interval;
    }

    /**
     * ヘルスチェック間隔(秒)を設定します。
     * 
     * @param interval
     *            ヘルスチェック間隔(秒)
     */
    public void setInterval(Integer interval) {
        this.interval = interval;
    }

    /**
     * ヘルスチェック間隔(秒)を設定し、自オブジェクトを返します。
     * 
     * @param interval
     *            ヘルスチェック間隔(秒)
     * @return 自オブジェクト
     */
    public HealthCheck withInterval(Integer interval) {
        setInterval(interval);
        return this;
    }

    /**
     * ヘルスチェック回数閾値を取得します。
     * 
     * @return ヘルスチェック回数閾値
     */
    @Query(name = "UnhealthyThreshold")
    public Integer getUnhealthyThreshold() {
        return unhealthyThreshold;
    }

    /**
     * ヘルスチェック回数閾値を設定します。
     * 
     * @param unhealthyThreshold
     *            ヘルスチェック回数閾値
     */
    public void setUnhealthyThreshold(Integer unhealthyThreshold) {
        this.unhealthyThreshold = unhealthyThreshold;
    }

    /**
     * ヘルスチェック回数閾値を設定し、自オブジェクトを返します。
     * 
     * @param unhealthyThreshold
     *            ヘルスチェック回数閾値
     * @return 自オブジェクト
     */
    public HealthCheck withUnhealthyThreshold(Integer unhealthyThreshold) {
        setUnhealthyThreshold(unhealthyThreshold);
        return this;
    }

    /**
     * ヘルスチェックパスを取得します。
     * 
     * @return ヘルスチェックパス
     */
    @Query(name = "Path")
    public String getPath() {
        return path;
    }

    /**
     * ヘルスチェックパスを設定します。
     * 
     * @param path
     *            ヘルスチェックパス
     */
    public void setPath(String path) {
        this.path = path;
    }

    /**
     * ヘルスチェックパスを設定し、自オブジェクトを返します。
     * 
     * @param path
     *            ヘルスチェックパス
     * @return 自オブジェクト
     */
    public HealthCheck withPath(String path) {
        setPath(path);
        return this;
    }

    /**
     * ヘルスチェック期待値を取得します。
     * 
     * @return ヘルスチェック期待値
     */
    @Query(name = "Expectation")
    public Expectation getExpectation() {
        return expectation;
    }

    /**
     * ヘルスチェック期待値を設定します。
     * 
     * @param expectation
     *            ヘルスチェック期待値
     */
    public void setExpectation(Expectation expectation) {
        this.expectation = expectation;
    }

    /**
     * ヘルスチェック期待値を設定し、自オブジェクトを返します。
     * 
     * @param expectation
     *            ヘルスチェック期待値
     * @return 自オブジェクト
     */
    public HealthCheck withExpectation(Expectation expectation) {
        setExpectation(expectation);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[target=");
        builder.append(target);
        builder.append(", interval=");
        builder.append(interval);
        builder.append(", unhealthyThreshold=");
        builder.append(unhealthyThreshold);
        builder.append(", path=");
        builder.append(path);
        builder.append(", expectation=");
        builder.append(expectation);

        builder.append("]");

        return builder.toString();
    }

}
