/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.annotation.Query;

/**
 * フィルタークラス。<br />
 * このクラスはフィルター情報を保持します。
 *
 */
public class Filter {

    /** 項目名 */
    private String name;

    /** 値のリスト */
    private List<String> value;

    /**
     * 項目名を取得します。
     * 
     * @return 項目名
     */
    @Query(name = "Name")
    public String getName() {
        return name;
    }

    /**
     * 項目名を設定します。
     * 
     * @param name
     *            項目名
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 項目名を設定し、自オブジェクトを返します。
     * 
     * @param name
     *            項目名
     * @return 自オブジェクト
     */
    public Filter withName(String name) {
        setName(name);
        return this;
    }

    /**
     * 値のリストを取得します。
     * 
     * @return 値のリスト
     */
    @Query(name = "Value")
    public List<String> getValue() {
        return value;
    }

    /**
     * 値のリストを設定します。
     * 
     * @param value
     *            値のリスト
     */
    public void setValue(List<String> value) {
        this.value = value;
    }

    /**
     * 値のリストを設定し、自オブジェクトを返します。
     * 
     * @param value
     *            値のリスト
     * @return 自オブジェクト
     */
    public Filter withValue(Collection<String> value) {

        if (this.value == null) {
            this.value = new ArrayList<String>();
        }

        if (value != null && !value.isEmpty()) {
            getValue().addAll(value);
        }

        return this;

    }

    /**
     * 値の配列を設定し、自オブジェクトを返します。
     * 
     * @param value
     *            値の配列
     * @return 自オブジェクト
     */
    public Filter withValue(String... value) {

        if (this.value == null) {
            this.value = new ArrayList<String>();
        }

        if (value != null && value.length > 0) {

            for (String str : value) {
                getValue().add(str);
            }

        }

        return this;

    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[name=");
        builder.append(name);

        builder.append(", value=");
        builder.append(value);

        builder.append("]");

        return builder.toString();
    }

}
