/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.annotation.Query;

/**
 * ヘルスチェック期待値メンバーリストクラス。<br />
 * このクラスは新規作成時のヘルスチェック期待値メンバーリストを保持します。
 *
 */
public class Expectation {

    /** ヘルスチェック期待値メンバーリスト */
    private List<ExpectationMember> memberList;

    /**
     * ヘルスチェック期待値メンバーリストを取得します。
     * 
     * @return ヘルスチェック期待値メンバーリスト
     */
    @Query(name = "member")
    public List<ExpectationMember> getMemberList() {
        return memberList;
    }

    /**
     * ヘルスチェック期待値メンバーリストを設定します。
     * 
     * @param memberList
     *            ヘルスチェック期待値メンバーリスト
     */
    public void setMemberList(List<ExpectationMember> memberList) {
        this.memberList = memberList;
    }

    /**
     * ヘルスチェック期待値メンバーリストを設定し、自オブジェクトを返します。
     * 
     * @param memberList
     *            ヘルスチェック期待値メンバーリスト
     * @return
     */
    public Expectation withMemberList(Collection<ExpectationMember> memberList) {

        if (this.memberList == null) {
            this.memberList = new ArrayList<ExpectationMember>();
        }

        if (memberList != null && !memberList.isEmpty()) {
            getMemberList().addAll(memberList);
        }

        return this;
    }

    /**
     * ヘルスチェック期待値メンバーの配列を設定し、自オブジェクトを返します。
     * 
     * @param memberList
     *            ヘルスチェック期待値メンバーリストの配列
     * @return
     */
    public Expectation withMemberList(ExpectationMember... memberList) {

        if (this.memberList == null) {
            this.memberList = new ArrayList<ExpectationMember>();
        }

        if (memberList != null && memberList.length > 0) {

            for (ExpectationMember work : memberList) {
                getMemberList().add(work);
            }

        }

        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[memberList=");
        builder.append(memberList);

        builder.append("]");

        return builder.toString();
    }

}
