/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.annotation.Query;

/**
 * マルチロードバランサーリスト保持クラス。<br />
 * このクラスはマルチロードバランサーリストを保持します。
 *
 */
public class ElasticLoadBalancers {

    /** マルチロードバランサーユニークIDリスト */
    private List<String> elasticLoadBalancerIdList = new ArrayList<String>();

    /** マルチロードバランサー名リスト */
    private List<String> elasticLoadBalancerNameList = new ArrayList<String>();

    /** プロトコルのリスト */
    private List<String> protocolList = new ArrayList<String>();

    /** 待ち受けポートのリスト */
    private List<Integer> elasticLoadBalancerPortList = new ArrayList<Integer>();

    /** 宛先ポートのリスト */
    private List<Integer> instancePortList = new ArrayList<Integer>();

    /**
     * マルチロードバランサーユニークIDリストを取得します。
     * 
     * @return マルチロードバランサーユニークIDリスト
     */
    @Query(name = "ElasticLoadBalancerId")
    public List<String> getElasticLoadBalancerIdList() {
        return elasticLoadBalancerIdList;
    }

    /**
     * マルチロードバランサーユニークIDリストを設定します。
     * 
     * @param elasticLoadBalancerIdList
     *            マルチロードバランサーユニークIDリスト
     */
    public void setElasticLoadBalancerIdList(List<String> elasticLoadBalancerIdList) {
        this.elasticLoadBalancerIdList = elasticLoadBalancerIdList;
    }

    /**
     * マルチロードバランサーユニークIDリストを設定し、自オブジェクトを返します。
     * 
     * @param elasticLoadBalancerIdList
     *            マルチロードバランサーユニークIDリスト
     * @return 自オブジェクト
     */
    public ElasticLoadBalancers
        withElasticLoadBalancerIdList(Collection<String> elasticLoadBalancerIdList) {

        if (this.elasticLoadBalancerIdList == null) {
            this.elasticLoadBalancerIdList = new ArrayList<String>();
        }

        if (elasticLoadBalancerIdList != null && !elasticLoadBalancerIdList.isEmpty()) {
            getElasticLoadBalancerIdList().addAll(elasticLoadBalancerIdList);
        }

        return this;
    }

    /**
     * マルチロードバランサーユニークIDの配列を設定し、自オブジェクトを返します。
     * 
     * @param elasticLoadBalancerId
     *            マルチロードバランサーユニークIDの配列
     * @return 自オブジェクト
     */
    public ElasticLoadBalancers
        withElasticLoadBalancerIdList(String... elasticLoadBalancerId) {

        if (elasticLoadBalancerIdList == null) {
            elasticLoadBalancerIdList = new ArrayList<String>();
        }

        if (elasticLoadBalancerId != null && elasticLoadBalancerId.length > 0) {

            for (String str : elasticLoadBalancerId) {
                getElasticLoadBalancerIdList().add(str);
            }

        }

        return this;
    }

    /**
     * マルチロードバランサー名リストを取得します。
     * 
     * @return マルチロードバランサー名リスト
     */
    @Query(name = "ElasticLoadBalancerName")
    public List<String> getElasticLoadBalancerNameList() {
        return elasticLoadBalancerNameList;
    }

    /**
     * マルチロードバランサー名リストを設定します。
     * 
     * @param elasticLoadBalancerNameList
     *            マルチロードバランサー名リスト
     */
    public void setElasticLoadBalancerNameList(List<String> elasticLoadBalancerNameList) {
        this.elasticLoadBalancerNameList = elasticLoadBalancerNameList;
    }

    /**
     * マルチロードバランサー名リストを設定し、自オブジェクトを返します。
     * 
     * @param elasticLoadBalancerNameList
     *            マルチロードバランサー名リスト
     * @return 自オブジェクト
     */
    public ElasticLoadBalancers
        withElasticLoadBalancerNameList(Collection<String> elasticLoadBalancerNameList) {

        if (this.elasticLoadBalancerNameList == null) {
            this.elasticLoadBalancerNameList = new ArrayList<String>();
        }

        if (elasticLoadBalancerNameList != null && !elasticLoadBalancerNameList.isEmpty()) {
            getElasticLoadBalancerNameList().addAll(elasticLoadBalancerNameList);
        }

        return this;

    }

    /**
     * マルチロードバランサー名の配列を設定し、自オブジェクトを返します。
     * 
     * @param elasticLoadBalancerName
     *            マルチロードバランサー名の配列
     * @return 自オブジェクト
     */
    public ElasticLoadBalancers withElasticLoadBalancerNameList(String... elasticLoadBalancerName) {

        if (this.elasticLoadBalancerNameList == null) {
            this.elasticLoadBalancerNameList = new ArrayList<String>();
        }

        if (elasticLoadBalancerName != null && elasticLoadBalancerName.length > 0) {

            for (String str : elasticLoadBalancerName) {
                getElasticLoadBalancerNameList().add(str);
            }

        }

        return this;

    }

    /**
     * プロトコルのリストを取得します。
     * 
     * @return プロトコルのリスト
     */
    @Query(name = "Protocol")
    public List<String> getProtocolList() {
        return protocolList;
    }

    /**
     * プロトコルのリストを設定します。
     * 
     * @param protocolList
     *            プロトコルのリスト
     */
    public void setProtocolList(List<String> protocolList) {
        this.protocolList = protocolList;
    }

    /**
     * プロトコルのリストを設定し、自オブジェクトを返します。
     * 
     * @param protocolList
     *            プロトコルのリスト
     */
    public ElasticLoadBalancers withProtocolList(Collection<String> protocolList) {

        if (this.protocolList == null) {
            this.protocolList = new ArrayList<String>();
        }

        if (protocolList != null && !protocolList.isEmpty()) {
            getProtocolList().addAll(protocolList);
        }

        return this;
    }

    /**
     * プロトコルの配列を設定し、自オブジェクトを返します。
     * 
     * @param protocolList
     *            プロトコルの配列
     */
    public ElasticLoadBalancers withProtocolList(String... protocol) {

        if (this.protocolList == null) {
            this.protocolList = new ArrayList<String>();
        }

        if (protocol != null && protocol.length > 0) {

            for (String str : protocol) {
                getProtocolList().add(str);
            }

        }

        return this;
    }

    /**
     * 待ち受けポートのリストを取得します。
     * 
     * @return 待ち受けポートのリスト
     */
    @Query(name = "ElasticLoadBalancerPort")
    public List<Integer> getElasticLoadBalancerPortList() {
        return elasticLoadBalancerPortList;
    }

    /**
     * 待ち受けポートのリストを設定します。
     * 
     * @param elasticLoadBalancerPortList
     *            待ち受けポートのリスト
     */
    public void setElasticLoadBalancerPortList(List<Integer> elasticLoadBalancerPortList) {
        this.elasticLoadBalancerPortList = elasticLoadBalancerPortList;
    }

    /**
     * 待ち受けポートのリストを設定し、自オブジェクトを返します。
     * 
     * @param elasticLoadBalancerPortList
     *            待ち受けポートのリスト
     * @return 自オブジェクト
     */
    public ElasticLoadBalancers
        withElasticLoadBalancerPortList(Collection<Integer> elasticLoadBalancerPortList) {

        if (this.elasticLoadBalancerPortList == null) {
            this.elasticLoadBalancerPortList = new ArrayList<Integer>();
        }

        if (elasticLoadBalancerPortList != null && !elasticLoadBalancerPortList.isEmpty()) {
            getElasticLoadBalancerPortList().addAll(elasticLoadBalancerPortList);
        }

        return this;

    }

    /**
     * 待ち受けポートの配列を設定し、自オブジェクトを返します。
     * 
     * @param elasticLoadBalancerPort
     *            待ち受けポートの配列
     * @return 自オブジェクト
     */
    public ElasticLoadBalancers
        withElasticLoadBalancerPortList(Integer... elasticLoadBalancerPort) {

        if (this.elasticLoadBalancerPortList == null) {
            this.elasticLoadBalancerPortList = new ArrayList<Integer>();
        }

        if (elasticLoadBalancerPort != null && elasticLoadBalancerPort.length > 0) {

            for (Integer num : elasticLoadBalancerPort) {
                getElasticLoadBalancerPortList().add(num);
            }

        }

        return this;

    }

    /**
     * 宛先ポートのリストを取得します。
     * 
     * @return 宛先ポートのリスト
     */
    @Query(name = "InstancePort")
    public List<Integer> getInstancePortList() {
        return instancePortList;
    }

    /**
     * 宛先ポートのリストを設定します。
     * 
     * @param instancePortList
     *            宛先ポートのリスト
     */
    public void setInstancePortList(List<Integer> instancePortList) {
        this.instancePortList = instancePortList;
    }

    /**
     * 宛先ポートのリストを設定し、自オブジェクトを返します。
     * 
     * @param instancePortList
     *            宛先ポートのリスト
     * @return 自オブジェクト
     */
    public ElasticLoadBalancers withInstancePortList(Collection<Integer> instancePortList) {

        if (this.instancePortList == null) {
            this.instancePortList = new ArrayList<Integer>();
        }

        if (instancePortList != null && !instancePortList.isEmpty()) {
            getInstancePortList().addAll(instancePortList);
        }

        return this;
    }

    /**
     * 宛先ポートの配列を設定し、自オブジェクトを返します。
     * 
     * @param instancePort
     *            宛先ポートの配列
     * @return 自オブジェクト
     */
    public ElasticLoadBalancers withInstancePortList(Integer... instancePort) {

        if (this.instancePortList == null) {
            this.instancePortList = new ArrayList<Integer>();
        }

        if (instancePort != null && instancePort.length > 0) {

            for (Integer num : instancePort) {
                getInstancePortList().add(num);
            }

        }

        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[elasticLoadBalancerIdList=");
        builder.append(elasticLoadBalancerIdList);

        builder.append(", elasticLoadBalancerNameList=");
        builder.append(elasticLoadBalancerNameList);

        builder.append(", protocolList=");
        builder.append(protocolList);

        builder.append(", elasticLoadBalancerPortList=");
        builder.append(elasticLoadBalancerPortList);

        builder.append(", instancePortList=");
        builder.append(instancePortList);

        builder.append("]");

        return builder.toString();
    }

}
