/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.multiloadbalancer.model.transform.AvailabilityZonesConverter;
import com.nifty.cloud.sdk.multiloadbalancer.model.transform.ElasticLoadBalancerListenerDescriptionsConverter;
import com.nifty.cloud.sdk.multiloadbalancer.model.transform.NetworkInterfacesConverter;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;

/**
 * マルチロードバランサーの情報クラス。<br />
 * このクラスはマルチロードバランサーの情報を格納します。
 */
public class ElasticLoadBalancerDescriptionsMember {

    /** マルチロードバランサーユニークID */
    @XStreamAlias("ElasticLoadBalancerId")
    private String elasticLoadBalancerId;

    /** マルチロードバランサー名 */
    @XStreamAlias("ElasticLoadBalancerName")
    private String elasticLoadBalancerName;

    /** VIPネットワークIPアドレス */
    @XStreamAlias("DNSName")
    private String dnsName;

    /** 最大ネットワーク流量 */
    @XStreamAlias("NetworkVolume")
    private String networkVolume;

    /** ステータス */
    @XStreamAlias("State")
    private String state;

    /** 当月の利用料金タイプ */
    @XStreamAlias("AccountingType")
    private String accountingType;

    /** 次月からの利用料金タイプ */
    @XStreamAlias("NextMonthAccountingType")
    private String nextMonthAccountingType;

    /** ポート設定情報 */
    @XStreamAlias("ElasticLoadBalancerListenerDescriptions")
    @XStreamConverter(ElasticLoadBalancerListenerDescriptionsConverter.class)
    private ElasticLoadBalancerListenerDescriptions elasticLoadBalancerListenerDescriptions;

    /** ゾーン情報 */
    @XStreamAlias("AvailabilityZones")
    @XStreamConverter(AvailabilityZonesConverter.class)
    private AvailabilityZones availabilityZones;

    /** ネットワークインターフェース情報セット */
    @XStreamAlias("NetworkInterfaces")
    @XStreamConverter(NetworkInterfacesConverter.class)
    private List<NetworkInterface> networkInterfaces;

    /** バージョン情報 */
    @XStreamAlias("VersionInformation")
    private VersionInformation versionInformation;

    /** 作成日時 */
    @XStreamAlias("CreatedTime")
    private String createdTime;

    /**
     * マルチロードバランサーユニークIDを取得します。
     * 
     * @return マルチロードバランサーユニークID
     */
    public String getElasticLoadBalancerId() {
        return elasticLoadBalancerId;
    }

    /**
     * マルチロードバランサーユニークIDを設定します。
     * 
     * @param elasticLoadBalancerId
     *            マルチロードバランサーユニークID
     */
    public void setElasticLoadBalancerId(String elasticLoadBalancerId) {
        this.elasticLoadBalancerId = elasticLoadBalancerId;
    }

    /**
     * マルチロードバランサーユニークIDを設定し、自オブジェクトを返します。
     * 
     * @param elasticLoadBalancerId
     *            マルチロードバランサーユニークID
     * @return 自オブジェクト
     */
    public ElasticLoadBalancerDescriptionsMember
        withElasticLoadBalancerId(String elasticLoadBalancerId) {
        setElasticLoadBalancerId(elasticLoadBalancerId);
        return this;
    }

    /**
     * マルチロードバランサー名を取得します。
     * 
     * @return マルチロードバランサー名
     */
    public String getElasticLoadBalancerName() {
        return elasticLoadBalancerName;
    }

    /**
     * マルチロードバランサー名を設定します。
     * 
     * @param elasticLoadBalancerName
     *            マルチロードバランサー名
     */
    public void setElasticLoadBalancerName(String elasticLoadBalancerName) {
        this.elasticLoadBalancerName = elasticLoadBalancerName;
    }

    /**
     * マルチロードバランサー名を設定し、自オブジェクトを返します。
     * 
     * @param elasticLoadBalancerName
     *            マルチロードバランサー名
     * @return 自オブジェクト
     */
    public ElasticLoadBalancerDescriptionsMember
        withElasticLoadBalancerName(String elasticLoadBalancerName) {
        setElasticLoadBalancerName(elasticLoadBalancerName);
        return this;
    }

    /**
     * VIPネットワークIPアドレスを取得します。
     * 
     * @return VIPネットワークIPアドレス
     */
    public String getDnsName() {
        return dnsName;
    }

    /**
     * VIPネットワークIPアドレスを設定します。
     * 
     * @param dnsName
     *            VIPネットワークIPアドレス
     */
    public void setDnsName(String dnsName) {
        this.dnsName = dnsName;
    }

    /**
     * VIPネットワークIPアドレスを設定し、自オブジェクトを返します。
     * 
     * @param dnsName
     *            VIPネットワークIPアドレス
     * @return 自オブジェクト
     */
    public ElasticLoadBalancerDescriptionsMember withDnsName(String dnsName) {
        setDnsName(dnsName);
        return this;
    }

    /**
     * 最大ネットワーク流量を取得します。
     * 
     * @return 最大ネットワーク流量
     */
    public String getNetworkVolume() {
        return networkVolume;
    }

    /**
     * 最大ネットワーク流量を設定します。
     * 
     * @param networkVolume
     *            最大ネットワーク流量
     */
    public void setNetworkVolume(String networkVolume) {
        this.networkVolume = networkVolume;
    }

    /**
     * 最大ネットワーク流量を設定し、自オブジェクトを返します。
     * 
     * @param networkVolume
     *            最大ネットワーク流量
     * @return 自オブジェクト
     */
    public ElasticLoadBalancerDescriptionsMember withNetworkVolume(String networkVolume) {
        setNetworkVolume(networkVolume);
        return this;
    }

    /**
     * ステータスを取得します。
     * 
     * @return ステータス
     */
    public String getState() {
        return state;
    }

    /**
     * ステータスを設定します。
     * 
     * @param state
     *            ステータス
     */
    public void setState(String state) {
        this.state = state;
    }

    /**
     * ステータスを設定し、自オブジェクトを返します。
     * 
     * @param state
     *            ステータス
     * @return 自オブジェクト
     */
    public ElasticLoadBalancerDescriptionsMember withState(String state) {
        setState(state);
        return this;
    }

    /**
     * 当月の利用料金タイプを取得します。
     * 
     * @return 当月の利用料金タイプ
     */
    public String getAccountingType() {
        return accountingType;
    }

    /**
     * 当月の利用料金タイプを設定します。
     * 
     * @param accountingType
     *            当月の利用料金タイプ
     */
    public void setAccountingType(String accountingType) {
        this.accountingType = accountingType;
    }

    /**
     * 当月の利用料金タイプを設定し、自オブジェクトを返します。
     * 
     * @param accountingType
     *            当月の利用料金タイプ
     * @return 自オブジェクト
     */
    public ElasticLoadBalancerDescriptionsMember withAccountingType(String accountingType) {
        setAccountingType(accountingType);
        return this;
    }

    /**
     * 次月からの利用料金タイプを取得します。
     * 
     * @return 次月からの利用料金タイプ
     */
    public String getNextMonthAccountingType() {
        return nextMonthAccountingType;
    }

    /**
     * 次月からの利用料金タイプを設定します。
     * 
     * @param nextMonthAccountingType
     *            次月からの利用料金タイプ
     */
    public void setNextMonthAccountingType(String nextMonthAccountingType) {
        this.nextMonthAccountingType = nextMonthAccountingType;
    }

    /**
     * 次月からの利用料金タイプを設定し、自オブジェクトを返します。
     * 
     * @param nextMonthAccountingType
     *            次月からの利用料金タイプ
     * @return 自オブジェクト
     */
    public ElasticLoadBalancerDescriptionsMember
        withNextMonthAccountingType(String nextMonthAccountingType) {
        setNextMonthAccountingType(nextMonthAccountingType);
        return this;
    }

    /**
     * ポート設定情報を取得します。
     * 
     * @return ポート設定情報
     */
    public ElasticLoadBalancerListenerDescriptions getElasticLoadBalancerListenerDescriptions() {
        return elasticLoadBalancerListenerDescriptions;
    }

    /**
     * ポート設定情報を設定します。
     * 
     * @param elasticLoadBalancerListenerDescriptions
     *            ポート設定情報
     */
    public void setElasticLoadBalancerListenerDescriptions(
        ElasticLoadBalancerListenerDescriptions elasticLoadBalancerListenerDescriptions) {
        this.elasticLoadBalancerListenerDescriptions = elasticLoadBalancerListenerDescriptions;
    }

    /**
     * ポート設定情報を設定し、自オブジェクトを返します。
     * 
     * @param elasticLoadBalancerListenerDescriptions
     *            ポート設定情報
     * @return 自オブジェクト
     */
    public ElasticLoadBalancerDescriptionsMember withElasticLoadBalancerListenerDescriptions(
        ElasticLoadBalancerListenerDescriptions elasticLoadBalancerListenerDescriptions) {
        setElasticLoadBalancerListenerDescriptions(elasticLoadBalancerListenerDescriptions);
        return this;
    }

    /**
     * ゾーン情報を取得します。
     * 
     * @return ゾーン情報
     */
    public AvailabilityZones getAvailabilityZones() {
        return availabilityZones;
    }

    /**
     * ゾーン情報を設定します。
     * 
     * @param availabilityZones
     *            ゾーン情報
     */
    public void setAvailabilityZones(AvailabilityZones availabilityZones) {
        this.availabilityZones = availabilityZones;
    }

    /**
     * ゾーン情報を設定し、自オブジェクトを返します。
     * 
     * @param availabilityZones ゾーン情報
     * @return 自オブジェクト
     */
    public ElasticLoadBalancerDescriptionsMember
        withAvailabilityZones(AvailabilityZones availabilityZones) {
        setAvailabilityZones(availabilityZones);
        return this;
    }

    /**
     * ネットワークインターフェース情報セットを取得します。
     * 
     * @return ネットワークインターフェース情報セット
     */
    public List<NetworkInterface> getNetworkInterfaces() {
        return networkInterfaces;
    }

    /**
     * ネットワークインターフェース情報セットを設定します。
     * 
     * @param networkInterfaces
     *            ネットワークインターフェース情報セット
     */
    public void setNetworkInterfaces(List<NetworkInterface> networkInterfaces) {
        this.networkInterfaces = networkInterfaces;
    }

    /**
     * ネットワークインターフェース情報セットを設定し、自オブジェクトを返します。
     * 
     * @param networkInterfaces
     *            ネットワークインターフェース情報セット
     * @return 自オブジェクト
     */
    public ElasticLoadBalancerDescriptionsMember
        withNetworkInterfaces(Collection<NetworkInterface> networkInterfaces) {

        if (this.networkInterfaces == null) {
            this.networkInterfaces = new ArrayList<NetworkInterface>();
        }

        if (networkInterfaces != null && !networkInterfaces.isEmpty()) {
            getNetworkInterfaces().addAll(networkInterfaces);
        }

        return this;
    }

    /**
     * ネットワークインターフェース情報の配列を設定し、自オブジェクトを返します。
     * 
     * @param networkInterfaces
     *            ネットワークインターフェース情報の配列
     * @return 自オブジェクト
     */
    public ElasticLoadBalancerDescriptionsMember
        withNetworkInterfaces(NetworkInterface... networkInterfaces) {

        if (this.networkInterfaces == null) {
            this.networkInterfaces = new ArrayList<NetworkInterface>();
        }

        if (networkInterfaces != null && networkInterfaces.length > 0) {

            for (NetworkInterface network : networkInterfaces) {
                getNetworkInterfaces().add(network);
            }

        }
        return this;
    }

    /**
     * バージョン情報を取得します。
     * 
     * @return バージョン情報
     */
    public VersionInformation getVersionInformation() {
        return versionInformation;
    }

    /**
     * バージョン情報を設定します。
     * 
     * @param versionInformation
     *            バージョン情報
     */
    public void setVersionInformation(VersionInformation versionInformation) {
        this.versionInformation = versionInformation;
    }

    /**
     * バージョン情報を設定し、自オブジェクトを返します。
     * 
     * @param versionInformation
     *            バージョン情報
     * @return 自オブジェクト
     */
    public ElasticLoadBalancerDescriptionsMember
        withVersionInformation(VersionInformation versionInformation) {
        setVersionInformation(versionInformation);
        return this;
    }

    /**
     * 作成日時を取得します。
     * 
     * @return 作成日時
     */
    public String getCreatedTime() {
        return createdTime;
    }

    /**
     * 作成日時を設定します。
     * 
     * @param createdTime
     *            作成日時
     */
    public void setCreatedTime(String createdTime) {
        this.createdTime = createdTime;
    }

    /**
     * 作成日時を設定し、自オブジェクトを返します。
     * 
     * @param createdTime
     *            作成日時
     * @return 自オブジェクト
     */
    public ElasticLoadBalancerDescriptionsMember withCreatedTime(String createdTime) {
        setCreatedTime(createdTime);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[elasticLoadBalancerId=");
        builder.append(elasticLoadBalancerId);

        builder.append(", elasticLoadBalancerName=");
        builder.append(elasticLoadBalancerName);

        builder.append(", dnsName=");
        builder.append(dnsName);

        builder.append(", networkVolume=");
        builder.append(networkVolume);

        builder.append(", state=");
        builder.append(state);

        builder.append(", accountingType=");
        builder.append(accountingType);

        builder.append(", nextMonthAccountingType=");
        builder.append(nextMonthAccountingType);

        builder.append(", elasticLoadBalancerListenerDescriptions=");
        builder.append(elasticLoadBalancerListenerDescriptions);

        builder.append(", availabilityZones=");
        builder.append(availabilityZones);

        builder.append(", networkInterfaces=");
        builder.append(networkInterfaces);

        builder.append(", versionInformation=");
        builder.append(versionInformation);

        builder.append(", createdTime=");
        builder.append(createdTime);

        builder.append("]");

        return builder.toString();
    }

}
