/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.thoughtworks.xstream.annotations.XStreamAlias;

/**
 * マルチロードバランサーの情報クラス。<br />
 * このクラスはマルチロードバランサーの情報を格納します。
 */

@XStreamAlias("ElasticLoadBalancerDescriptions")
public class ElasticLoadBalancerDescriptions {

    /** マルチロードバランサー情報 */
    @XStreamAlias("member")
    private List<ElasticLoadBalancerDescriptionsMember> member;

    /**
     * マルチロードバランサー情報を取得します。
     * 
     * @return マルチロードバランサー情報
     */
    public List<ElasticLoadBalancerDescriptionsMember> getMember() {
        return member;
    }

    /**
     * マルチロードバランサー情報を設定します。
     * 
     * @param member
     *            マルチロードバランサー情報
     */
    public void setMember(List<ElasticLoadBalancerDescriptionsMember> member) {
        this.member = member;
    }

    /**
     * マルチロードバランサー情報を設定し、自オブジェクトを返します。
     * 
     * @param member
     *            マルチロードバランサー情報
     * @return 自オブジェクト
     */
    public ElasticLoadBalancerDescriptions
        withMember(Collection<ElasticLoadBalancerDescriptionsMember> member) {

        if (this.member == null) {
            this.member = new ArrayList<ElasticLoadBalancerDescriptionsMember>();
        }

        if (member != null && !member.isEmpty()) {
            getMember().addAll(member);
        }

        return this;
    }

    /**
     * マルチロードバランサー情報の配列を設定し、自オブジェクトを返します。
     * 
     * @param member
     *            マルチロードバランサー情報の配列
     * @return 自オブジェクト
     */
    public ElasticLoadBalancerDescriptions
        withMember(ElasticLoadBalancerDescriptionsMember... member) {

        if (this.member == null) {
            this.member = new ArrayList<ElasticLoadBalancerDescriptionsMember>();
        }

        if (member != null && member.length != 0) {
            for (ElasticLoadBalancerDescriptionsMember work : member) {
                getMember().add(work);
            }
        }

        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[member=");
        builder.append(member);

        builder.append("]");

        return builder.toString();
    }

}
