/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model;

/**
 * マルチロードバランサーのポート設定情報(メンバー)クラス。<br />
 * このクラスはマルチロードバランサーのポート設定情報を格納します。
 */
public class DescriptionMember {

    /** リスナー情報 */
    private ListenerDescribe listenerDescribe;

    /**
     * リスナー情報を取得します。
     * 
     * @return リスナー情報
     */
    public ListenerDescribe getListenerDescribe() {
        return listenerDescribe;
    }

    /**
     * リスナー情報を設定します。
     * 
     * @param listenerDescribe
     *            リスナー情報
     */
    public void setListenerDescribe(ListenerDescribe listenerDescribe) {
        this.listenerDescribe = listenerDescribe;
    }

    /**
     * リスナー情報を設定し、自オブジェクトを返します。
     * 
     * @param listenerDescribe
     *            リスナー情報
     * @return 自オブジェクト
     */
    public DescriptionMember withListenerDescribe(ListenerDescribe listenerDescribe) {
        setListenerDescribe(listenerDescribe);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[listenerDescribe=");
        builder.append(listenerDescribe);

        builder.append("]");

        return builder.toString();
    }

}
