/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.annotation.Query;

/**
 * ゾーン情報クラス。<br />
 * このクラスはゾーン情報リストを保持します。
 *
 */
public class AvailabilityZones {

    /** ゾーン情報リスト */
    private List<String> member = new ArrayList<String>();

    /**
     * ゾーン情報リストを取得します。
     * 
     * @return ゾーン情報リスト
     */
    @Query(name = "member")
    public List<String> getMember() {
        return member;
    }

    /**
     * ゾーン情報リストを設定します。
     * 
     * @param member
     *            ゾーン情報リスト
     */
    public void setMember(List<String> member) {
        this.member = member;
    }

    /**
     * ゾーン情報リストを設定し、自オブジェクトを返します。
     * 
     * @param member
     *            ゾーン情報リスト
     * @return 自オブジェクト
     */
    public AvailabilityZones withMember(Collection<String> member) {

        if (this.member == null) {
            this.member = new ArrayList<String>();
        }

        if (member != null && !member.isEmpty()) {
            getMember().addAll(member);
        }

        return this;
    }

    /**
     * ゾーン情報の配列を設定し、自オブジェクトを返します。
     * 
     * @param member
     *            ゾーン情報の配列
     * @return 自オブジェクト
     */
    public AvailabilityZones withMember(String... member) {

        if (this.member == null) {
            this.member = new ArrayList<String>();
        }

        if (member != null && member.length > 0) {

            for (String str : member) {
                getMember().add(str);
            }

        }

        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[member=");
        builder.append(member);

        builder.append("]");

        return builder.toString();
    }

}
