/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model;

import com.nifty.cloud.sdk.annotation.Query;

/**
 * 更新対象項目クラス。<br />
 * このクラスは更新対象の項目を保持します。
 *
 */
public class AdditionalAttributesMember {

    /** 項目名 */
    private String key;

    /** 更新値 */
    private String value;

    /**
     * 項目名を取得します。
     * 
     * @return 項目名
     */
    @Query(name = "Key")
    public String getKey() {
        return key;
    }

    /**
     * 項目名を設定します。
     * 
     * @param key
     *            項目名
     */
    public void setKey(String key) {
        this.key = key;
    }

    /**
     * 項目名を設定し、自オブジェクトを返します。
     * 
     * @param key
     *            項目名
     * @return 自オブジェクト
     */
    public AdditionalAttributesMember withKey(String key) {
        setKey(key);
        return this;
    }

    /**
     * 更新値を取得します。
     * 
     * @return 更新値
     */
    @Query(name = "Value")
    public String getValue() {
        return value;
    }

    /**
     * 更新値を設定します。
     * 
     * @param value
     *            更新値
     */
    public void setValue(String value) {
        this.value = value;
    }

    /**
     * 更新値を設定し、自オブジェクトを返します。
     * 
     * @param value
     *            更新値
     * @return 自オブジェクト
     */
    public AdditionalAttributesMember withValue(String value) {
        setValue(value);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[key=");
        builder.append(key);
        builder.append(", value=");
        builder.append(value);

        builder.append("]");

        return builder.toString();
    }

}
