/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.annotation.Query;

/**
 * 更新対象リストクラス。<br />
 * このクラスは更新対象のリストを保持します。
 *
 */
public class AdditionalAttributes {

    /** 更新対象メンバーリスト */
    private List<AdditionalAttributesMember> memberList;

    /**
     * 更新対象メンバーリストを取得します。
     * 
     * @return 更新対象メンバーリスト
     */
    @Query(name = "member")
    public List<AdditionalAttributesMember> getMemberList() {
        return memberList;
    }

    /**
     * 更新対象メンバーリストを設定します。
     * 
     * @param memberList
     *            更新対象メンバーリスト
     */
    public void setMemberList(List<AdditionalAttributesMember> memberList) {
        this.memberList = memberList;
    }

    /**
     * 更新対象メンバーリストを設定し、自オブジェクトを返します。
     * 
     * @param memberList
     *            更新対象メンバーリスト
     * @return 自オブジェクト
     */
    public AdditionalAttributes withMemberList(Collection<AdditionalAttributesMember> memberList) {

        if (this.memberList == null) {
            this.memberList = new ArrayList<AdditionalAttributesMember>();
        }

        if (!memberList.isEmpty()) {
            getMemberList().addAll(memberList);
        }

        return this;
    }

    /**
     * 更新対象メンバーリストの配列を設定し、自オブジェクトを返します。
     * 
     * @param memberList
     *            更新対象メンバーリストの配列
     * @return 自オブジェクト
     */
    public AdditionalAttributes withMemberList(AdditionalAttributesMember... memberList) {

        if (this.memberList == null) {
            this.memberList = new ArrayList<AdditionalAttributesMember>();
        }

        if (memberList != null && memberList.length > 0) {

            for (AdditionalAttributesMember work : memberList) {
                getMemberList().add(work);
            }

        }

        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[memberList=");
        builder.append(memberList);

        builder.append("]");

        return builder.toString();
    }

}
