/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer;

import com.nifty.cloud.sdk.BaseClient;
import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.auth.Credentials;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyConfigureElasticLoadBalancerHealthCheckRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyConfigureElasticLoadBalancerHealthCheckResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyCreateElasticLoadBalancerRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyCreateElasticLoadBalancerResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyDeleteElasticLoadBalancerRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyDeleteElasticLoadBalancerResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyDeregisterInstancesFromElasticLoadBalancerRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyDeregisterInstancesFromElasticLoadBalancerResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyDescribeElasticLoadBalancersRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyDescribeElasticLoadBalancersResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyDescribeInstanceElasticLoadBalancerHealthRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyDescribeInstanceElasticLoadBalancerHealthResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyModifyElasticLoadBalancerAttributesRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyModifyElasticLoadBalancerAttributesResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyRegisterInstancesWithElasticLoadBalancerRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyRegisterInstancesWithElasticLoadBalancerResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyRegisterPortWithElasticLoadBalancerRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyRegisterPortWithElasticLoadBalancerResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyReplaceElasticLoadBalancerLatestVersionRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyReplaceElasticLoadBalancerLatestVersionResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyReplaceElasticLoadBalancerListenerSSLCertificateRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyReplaceElasticLoadBalancerListenerSSLCertificateResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyUpdateElasticLoadBalancerRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyUpdateElasticLoadBalancerResult;

/**
 * NIFCLOUD API クライアント 具象クラス。 マルチロードバランサーカテゴリ クライアント。<br />
 * マルチロードバランサー カテゴリの同期クライアントの具象クラスです。
 *
 */
public class NiftyMultiLoadBalancerClient extends BaseClient implements NiftyMultiLoadBalancer {

    /**
     * 認証情報を指定し、マルチロードバランサーカテゴリクライアントを構築します。
     *
     * @param credential
     *            認証情報
     */
    public NiftyMultiLoadBalancerClient(Credentials credential) {
        super(credential, new ClientConfiguration());
    }

    /**
     * 認証情報、クライアント設定を指定し、マルチロードバランサーカテゴリクライアントを構築します。
     *
     * @param credential
     *            認証情報
     * @param configuration
     *            クライアント設定
     */
    public NiftyMultiLoadBalancerClient(Credentials credential, ClientConfiguration configuration) {
        super(credential, configuration);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NiftyConfigureElasticLoadBalancerHealthCheckResult
        niftyConfigureElasticLoadBalancerHealthCheck(
            NiftyConfigureElasticLoadBalancerHealthCheckRequest request) {
        return (NiftyConfigureElasticLoadBalancerHealthCheckResult) client.execute(request,
            NiftyConfigureElasticLoadBalancerHealthCheckResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NiftyCreateElasticLoadBalancerResult
        niftyCreateElasticLoadBalancer(NiftyCreateElasticLoadBalancerRequest request) {
        return (NiftyCreateElasticLoadBalancerResult) client.execute(request,
            NiftyCreateElasticLoadBalancerResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NiftyDeleteElasticLoadBalancerResult
        niftyDeleteElasticLoadBalancer(NiftyDeleteElasticLoadBalancerRequest request) {
        return (NiftyDeleteElasticLoadBalancerResult) client.execute(request,
            NiftyDeleteElasticLoadBalancerResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NiftyDeregisterInstancesFromElasticLoadBalancerResult
        niftyDeregisterInstancesFromElasticLoadBalancer(
            NiftyDeregisterInstancesFromElasticLoadBalancerRequest request) {

        return (NiftyDeregisterInstancesFromElasticLoadBalancerResult) client.execute(request,
            NiftyDeregisterInstancesFromElasticLoadBalancerResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NiftyDescribeInstanceElasticLoadBalancerHealthResult
        niftyDescribeInstanceElasticLoadBalancerHealth(
            NiftyDescribeInstanceElasticLoadBalancerHealthRequest request) {
        return (NiftyDescribeInstanceElasticLoadBalancerHealthResult) client.execute(request,
            NiftyDescribeInstanceElasticLoadBalancerHealthResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NiftyDescribeElasticLoadBalancersResult
        niftyDescribeElasticLoadBalancers(NiftyDescribeElasticLoadBalancersRequest request) {
        return (NiftyDescribeElasticLoadBalancersResult) client.execute(request,
            NiftyDescribeElasticLoadBalancersResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NiftyModifyElasticLoadBalancerAttributesResult niftyModifyElasticLoadBalancerAttributes(
        NiftyModifyElasticLoadBalancerAttributesRequest request) {
        return (NiftyModifyElasticLoadBalancerAttributesResult) client.execute(request,
            NiftyModifyElasticLoadBalancerAttributesResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NiftyRegisterInstancesWithElasticLoadBalancerResult
        niftyRegisterInstancesWithElasticLoadBalancer(
            NiftyRegisterInstancesWithElasticLoadBalancerRequest request) {
        return (NiftyRegisterInstancesWithElasticLoadBalancerResult) client.execute(request,
            NiftyRegisterInstancesWithElasticLoadBalancerResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NiftyRegisterPortWithElasticLoadBalancerResult niftyRegisterPortWithElasticLoadBalancer(
        NiftyRegisterPortWithElasticLoadBalancerRequest request) {
        return (NiftyRegisterPortWithElasticLoadBalancerResult) client.execute(request,
            NiftyRegisterPortWithElasticLoadBalancerResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NiftyUpdateElasticLoadBalancerResult
        niftyUpdateElasticLoadBalancer(NiftyUpdateElasticLoadBalancerRequest request) {
        return (NiftyUpdateElasticLoadBalancerResult) client.execute(request,
            NiftyUpdateElasticLoadBalancerResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NiftyReplaceElasticLoadBalancerLatestVersionResult
        niftyReplaceElasticLoadBalancerLatestVersion(
            NiftyReplaceElasticLoadBalancerLatestVersionRequest request) {
        return (NiftyReplaceElasticLoadBalancerLatestVersionResult) client.execute(request,
            NiftyReplaceElasticLoadBalancerLatestVersionResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NiftyReplaceElasticLoadBalancerListenerSSLCertificateResult
        niftyReplaceElasticLoadBalancerListenerSSLCertificate(
            NiftyReplaceElasticLoadBalancerListenerSSLCertificateRequest request) {
        return (NiftyReplaceElasticLoadBalancerListenerSSLCertificateResult) client.execute(request,
            NiftyReplaceElasticLoadBalancerListenerSSLCertificateResult.class);
    }

}
