/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.auth.Credentials;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyConfigureElasticLoadBalancerHealthCheckRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyConfigureElasticLoadBalancerHealthCheckResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyCreateElasticLoadBalancerRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyCreateElasticLoadBalancerResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyDeleteElasticLoadBalancerRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyDeleteElasticLoadBalancerResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyDeregisterInstancesFromElasticLoadBalancerRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyDeregisterInstancesFromElasticLoadBalancerResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyDescribeElasticLoadBalancersRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyDescribeElasticLoadBalancersResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyDescribeInstanceElasticLoadBalancerHealthRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyDescribeInstanceElasticLoadBalancerHealthResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyModifyElasticLoadBalancerAttributesRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyModifyElasticLoadBalancerAttributesResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyRegisterInstancesWithElasticLoadBalancerRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyRegisterInstancesWithElasticLoadBalancerResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyRegisterPortWithElasticLoadBalancerRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyRegisterPortWithElasticLoadBalancerResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyReplaceElasticLoadBalancerLatestVersionRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyReplaceElasticLoadBalancerLatestVersionResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyReplaceElasticLoadBalancerListenerSSLCertificateRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyReplaceElasticLoadBalancerListenerSSLCertificateResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyUpdateElasticLoadBalancerRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyUpdateElasticLoadBalancerResult;

/**
 * NIFCLOUD API 非同期クライアント 具象クラス。 マルチロードバランサーカテゴリクライアント。<br />
 * マルチロードバランサー カテゴリの非同期クライアントの具象クラスです。
 *
 */
public class NiftyMultiLoadBalancerAsyncClient extends NiftyMultiLoadBalancerClient
    implements NiftyMultiLoadBalancerAsync {

    /** 非同期タスク実行クラス. */
    protected ExecutorService executorService = null;

    /**
     * 認証情報を指定し、マルチロードバランサーカテゴリクライアントを構築します。
     *
     * @param credential
     *            認証情報
     */
    public NiftyMultiLoadBalancerAsyncClient(Credentials credential) {
        this(credential, Executors.newCachedThreadPool());
    }

    /**
     * 認証情報、クライアント設定を指定し、マルチロードバランサーカテゴリクライアントを構築します。
     *
     * @param credential
     *            認証情報
     * @param configuration
     *            クライアント設定
     */
    public NiftyMultiLoadBalancerAsyncClient(Credentials credential,
        ClientConfiguration configuration) {
        this(credential, configuration, Executors.newCachedThreadPool());
    }

    /**
     * 認証情報,非同期タスク実行クラスを指定し、マルチロードバランサーカテゴリクライアントを構築します。
     *
     * @param credential
     *            認証情報
     * @param executorService
     *            非同期タスク実行クラス
     */
    public NiftyMultiLoadBalancerAsyncClient(Credentials credential,
        ExecutorService executorService) {
        super(credential);
        this.executorService = executorService;

    }

    /**
     * 認証情報、クライアント設定,非同期タスク実行クラスを指定し、マルチロードバランサーカテゴリクライアントを構築します。
     *
     * @param credential
     *            認証情報
     * @param configuration
     *            クライアント設定
     * @param executorService
     *            非同期タスク実行クラス
     */
    public NiftyMultiLoadBalancerAsyncClient(Credentials credential,
        ClientConfiguration configuration,
        ExecutorService executorService) {
        super(credential, configuration);
        this.executorService = executorService;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Future<NiftyConfigureElasticLoadBalancerHealthCheckResult>
        niftyConfigureElasticLoadBalancerHealthCheckAsync(
            final NiftyConfigureElasticLoadBalancerHealthCheckRequest request) {
        return executorService.submit(
            new Callable<NiftyConfigureElasticLoadBalancerHealthCheckResult>() {
                @Override
                public NiftyConfigureElasticLoadBalancerHealthCheckResult call() {
                    return niftyConfigureElasticLoadBalancerHealthCheck(request);
                }
            });
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Future<NiftyCreateElasticLoadBalancerResult>
        niftyCreateElasticLoadBalancerAsync(final NiftyCreateElasticLoadBalancerRequest request) {
        return executorService.submit(
            new Callable<NiftyCreateElasticLoadBalancerResult>() {
                @Override
                public NiftyCreateElasticLoadBalancerResult call() {
                    return niftyCreateElasticLoadBalancer(request);
                }
            });
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Future<NiftyDeleteElasticLoadBalancerResult>
        niftyDeleteElasticLoadBalancerAsync(final NiftyDeleteElasticLoadBalancerRequest request) {
        return executorService.submit(
            new Callable<NiftyDeleteElasticLoadBalancerResult>() {
                @Override
                public NiftyDeleteElasticLoadBalancerResult call() {
                    return niftyDeleteElasticLoadBalancer(request);
                }
            });
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Future<NiftyDeregisterInstancesFromElasticLoadBalancerResult>
        niftyDeregisterInstancesFromElasticLoadBalancerAsync(
            final NiftyDeregisterInstancesFromElasticLoadBalancerRequest request) {
        return executorService.submit(
            new Callable<NiftyDeregisterInstancesFromElasticLoadBalancerResult>() {
                @Override
                public NiftyDeregisterInstancesFromElasticLoadBalancerResult call() {
                    return niftyDeregisterInstancesFromElasticLoadBalancer(request);
                }
            });
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Future<NiftyDescribeInstanceElasticLoadBalancerHealthResult>
        niftyDescribeInstanceElasticLoadBalancerHealthAsync(
            final NiftyDescribeInstanceElasticLoadBalancerHealthRequest request) {
        return executorService.submit(
            new Callable<NiftyDescribeInstanceElasticLoadBalancerHealthResult>() {
                @Override
                public NiftyDescribeInstanceElasticLoadBalancerHealthResult call() {
                    return niftyDescribeInstanceElasticLoadBalancerHealth(request);
                }
            });
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Future<NiftyDescribeElasticLoadBalancersResult>
        niftyDescribeElasticLoadBalancersAsync(
            final NiftyDescribeElasticLoadBalancersRequest request) {
        return executorService.submit(
            new Callable<NiftyDescribeElasticLoadBalancersResult>() {
                @Override
                public NiftyDescribeElasticLoadBalancersResult call() {
                    return niftyDescribeElasticLoadBalancers(request);
                }
            });
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Future<NiftyModifyElasticLoadBalancerAttributesResult>
        niftyModifyElasticLoadBalancerAttributesAsync(
            final NiftyModifyElasticLoadBalancerAttributesRequest request) {
        return executorService.submit(
            new Callable<NiftyModifyElasticLoadBalancerAttributesResult>() {
                @Override
                public NiftyModifyElasticLoadBalancerAttributesResult call() {
                    return niftyModifyElasticLoadBalancerAttributes(request);
                }
            });
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Future<NiftyRegisterInstancesWithElasticLoadBalancerResult>
        niftyRegisterInstancesWithElasticLoadBalancerAsync(
            final NiftyRegisterInstancesWithElasticLoadBalancerRequest request) {
        return executorService.submit(
            new Callable<NiftyRegisterInstancesWithElasticLoadBalancerResult>() {
                @Override
                public NiftyRegisterInstancesWithElasticLoadBalancerResult call() {
                    return niftyRegisterInstancesWithElasticLoadBalancer(request);
                }
            });
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Future<NiftyRegisterPortWithElasticLoadBalancerResult>
        niftyRegisterPortWithElasticLoadBalancerAsync(
            final NiftyRegisterPortWithElasticLoadBalancerRequest request) {
        return executorService.submit(
            new Callable<NiftyRegisterPortWithElasticLoadBalancerResult>() {
                @Override
                public NiftyRegisterPortWithElasticLoadBalancerResult call() {
                    return niftyRegisterPortWithElasticLoadBalancer(request);
                }
            });
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Future<NiftyUpdateElasticLoadBalancerResult>
        niftyUpdateElasticLoadBalancerAsync(final NiftyUpdateElasticLoadBalancerRequest request) {
        return executorService.submit(
            new Callable<NiftyUpdateElasticLoadBalancerResult>() {
                @Override
                public NiftyUpdateElasticLoadBalancerResult call() {
                    return niftyUpdateElasticLoadBalancer(request);
                }
            });
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Future<NiftyReplaceElasticLoadBalancerLatestVersionResult>
        niftyReplaceElasticLoadBalancerLatestVersionAsync(
            final NiftyReplaceElasticLoadBalancerLatestVersionRequest request) {
        return executorService.submit(
            new Callable<NiftyReplaceElasticLoadBalancerLatestVersionResult>() {
                @Override
                public NiftyReplaceElasticLoadBalancerLatestVersionResult call() {
                    return niftyReplaceElasticLoadBalancerLatestVersion(request);
                }
            });
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Future<NiftyReplaceElasticLoadBalancerListenerSSLCertificateResult>
        niftyReplaceElasticLoadBalancerListenerSSLCertificateAsync(
            final NiftyReplaceElasticLoadBalancerListenerSSLCertificateRequest request) {
        return executorService.submit(
            new Callable<NiftyReplaceElasticLoadBalancerListenerSSLCertificateResult>() {
                @Override
                public NiftyReplaceElasticLoadBalancerListenerSSLCertificateResult call() {
                    return niftyReplaceElasticLoadBalancerListenerSSLCertificate(request);
                }
            });
    }

}
