/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer;

import java.util.concurrent.Future;

import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyConfigureElasticLoadBalancerHealthCheckRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyConfigureElasticLoadBalancerHealthCheckResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyCreateElasticLoadBalancerRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyCreateElasticLoadBalancerResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyDeleteElasticLoadBalancerRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyDeleteElasticLoadBalancerResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyDeregisterInstancesFromElasticLoadBalancerRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyDeregisterInstancesFromElasticLoadBalancerResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyDescribeElasticLoadBalancersRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyDescribeElasticLoadBalancersResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyDescribeInstanceElasticLoadBalancerHealthRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyDescribeInstanceElasticLoadBalancerHealthResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyModifyElasticLoadBalancerAttributesRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyModifyElasticLoadBalancerAttributesResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyRegisterInstancesWithElasticLoadBalancerRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyRegisterInstancesWithElasticLoadBalancerResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyRegisterPortWithElasticLoadBalancerRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyRegisterPortWithElasticLoadBalancerResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyReplaceElasticLoadBalancerLatestVersionRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyReplaceElasticLoadBalancerLatestVersionResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyReplaceElasticLoadBalancerListenerSSLCertificateRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyReplaceElasticLoadBalancerListenerSSLCertificateResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyUpdateElasticLoadBalancerRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyUpdateElasticLoadBalancerResult;

/**
 * NIFCLOUD API 非同期クライアント インタフェース。 マルチロードバランサーカテゴリクライアント。<br />
 * マルチロードバランサー カテゴリの非同期クライアントのインタフェースです。
 *
 */
public interface NiftyMultiLoadBalancerAsync extends NiftyMultiLoadBalancer {

    /**
     * 非同期で指定したマルチロードバランサーのヘルスチェックの設定を変更します。
     *
     * @param request
     *            NiftyConfigureElasticLoadBalancerHealthCheckリクエスト
     * @return 非同期処理結果
     */
    public Future<NiftyConfigureElasticLoadBalancerHealthCheckResult>
        niftyConfigureElasticLoadBalancerHealthCheckAsync(
            NiftyConfigureElasticLoadBalancerHealthCheckRequest request);

    /**
     * 非同期でマルチロードバランサーを作成します。
     *
     * @param request
     *            NiftyCreateElasticLoadBalancerリクエスト
     * @return 非同期処理結果
     */
    public Future<NiftyCreateElasticLoadBalancerResult>
        niftyCreateElasticLoadBalancerAsync(
            NiftyCreateElasticLoadBalancerRequest request);

    /**
     * 非同期で指定したマルチロードバランサーのポートを削除します。
     *
     * @param request
     *            NiftyDeleteElasticLoadBalancerリクエスト
     * @return 非同期処理結果
     */
    public Future<NiftyDeleteElasticLoadBalancerResult>
        niftyDeleteElasticLoadBalancerAsync(NiftyDeleteElasticLoadBalancerRequest request);

    /**
     * 非同期で指定したマルチロードバランサーから、指定したサーバーを解除します。
     *
     * @param request
     *            NiftyDeregisterInstancesFromElasticLoadBalancerリクエスト
     * @return 非同期処理結果
     */
    public Future<NiftyDeregisterInstancesFromElasticLoadBalancerResult>
        niftyDeregisterInstancesFromElasticLoadBalancerAsync(
            NiftyDeregisterInstancesFromElasticLoadBalancerRequest request);

    /**
     * 非同期で指定したマルチロードバランサーに設定されている、サーバーのヘルスチェック結果を取得します。
     *
     * @param request
     *            NiftyDescribeInstanceElasticLoadBalancerHealthリクエスト
     * @return 非同期処理結果
     */
    public Future<NiftyDescribeInstanceElasticLoadBalancerHealthResult>
        niftyDescribeInstanceElasticLoadBalancerHealthAsync(
            NiftyDescribeInstanceElasticLoadBalancerHealthRequest request);

    /**
     * 非同期で指定したマルチロードバランサーの情報を取得します。
     *
     * @param request
     *            NiftyDescribeElasticLoadBalancersリクエスト
     * @return 非同期処理結果
     */
    public Future<NiftyDescribeElasticLoadBalancersResult>
        niftyDescribeElasticLoadBalancersAsync(
            NiftyDescribeElasticLoadBalancersRequest request);

    /**
     * 非同期で指定したマルチロードバランサーの詳細情報を更新します。
     *
     * @param request
     *            NiftyRegisterInstancesWithElasticLoadBalancerリクエスト
     * @return 非同期処理結果
     */
    public Future<NiftyModifyElasticLoadBalancerAttributesResult>
        niftyModifyElasticLoadBalancerAttributesAsync(
            NiftyModifyElasticLoadBalancerAttributesRequest request);

    /**
     * 非同期で指定したマルチロードバランサーにサーバーを追加します。
     *
     * @param request
     *            NiftyRegisterInstancesWithElasticLoadBalancerリクエスト
     * @return 非同期処理結果
     */
    public Future<NiftyRegisterInstancesWithElasticLoadBalancerResult>
        niftyRegisterInstancesWithElasticLoadBalancerAsync(
            NiftyRegisterInstancesWithElasticLoadBalancerRequest request);

    /**
     * 非同期で指定したマルチロードバランサーにポートを追加します。
     *
     * @param request
     *            NiftyRegisterPortWithElasticLoadBalancerリクエスト
     * @return 非同期処理結果
     */
    public Future<NiftyRegisterPortWithElasticLoadBalancerResult>
        niftyRegisterPortWithElasticLoadBalancerAsync(
            NiftyRegisterPortWithElasticLoadBalancerRequest request);

    /**
     * 非同期で指定したマルチロードバランサーの設定を変更します。
     *
     * @param request
     *            NiftyUpdateElasticLoadBalancerリクエスト
     * @return 非同期処理結果
     */
    public Future<NiftyUpdateElasticLoadBalancerResult>
        niftyUpdateElasticLoadBalancerAsync(
            NiftyUpdateElasticLoadBalancerRequest request);

    /**
     * 非同期で指定したマルチロードバランサーを最新バージョンに入れ替えます。
     *
     * @param request
     *            NiftyReplaceElasticLoadBalancerLatestVersionリクエスト
     * @return 非同期処理結果
     */
    public Future<NiftyReplaceElasticLoadBalancerLatestVersionResult>
        niftyReplaceElasticLoadBalancerLatestVersionAsync(
            NiftyReplaceElasticLoadBalancerLatestVersionRequest request);

    /**
     * 非同期で指定したマルチロードバランサーに対してSSL証明書を入れ替えます。
     *
     * @param request
     *            NiftyReplaceElasticLoadBalancerListenerSSLCertificateリクエスト
     * @return 非同期処理結果
     */
    public Future<NiftyReplaceElasticLoadBalancerListenerSSLCertificateResult>
        niftyReplaceElasticLoadBalancerListenerSSLCertificateAsync(
            NiftyReplaceElasticLoadBalancerListenerSSLCertificateRequest request);

}
