/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer;

import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyConfigureElasticLoadBalancerHealthCheckRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyConfigureElasticLoadBalancerHealthCheckResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyCreateElasticLoadBalancerRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyCreateElasticLoadBalancerResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyDeleteElasticLoadBalancerRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyDeleteElasticLoadBalancerResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyDeregisterInstancesFromElasticLoadBalancerRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyDeregisterInstancesFromElasticLoadBalancerResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyDescribeElasticLoadBalancersRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyDescribeElasticLoadBalancersResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyDescribeInstanceElasticLoadBalancerHealthRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyDescribeInstanceElasticLoadBalancerHealthResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyModifyElasticLoadBalancerAttributesRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyModifyElasticLoadBalancerAttributesResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyRegisterInstancesWithElasticLoadBalancerRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyRegisterInstancesWithElasticLoadBalancerResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyRegisterPortWithElasticLoadBalancerRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyRegisterPortWithElasticLoadBalancerResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyReplaceElasticLoadBalancerLatestVersionRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyReplaceElasticLoadBalancerLatestVersionResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyReplaceElasticLoadBalancerListenerSSLCertificateRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyReplaceElasticLoadBalancerListenerSSLCertificateResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyUpdateElasticLoadBalancerRequest;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyUpdateElasticLoadBalancerResult;

/**
 * NIFCLOUD API クライアント インタフェース。 マルチロードバランサー カテゴリ クライアント。<br />
 * マルチロードバランサー カテゴリの同期クライアントのインタフェースです。
 *
 */
public interface NiftyMultiLoadBalancer {

    /**
     * エンドポイントの設定を行います。
     *
     * @param endpoint
     *            エンドポイント
     */
    public void setEndpoint(String endpoint);

    /**
     * 指定したマルチロードバランサーのヘルスチェックの設定を変更します。
     *
     * @param request
     *            NiftyConfigureElasticLoadBalancerHealthCheckリクエスト
     * @return NiftyConfigureElasticLoadBalancerHealthCheck処理結果
     */
    public NiftyConfigureElasticLoadBalancerHealthCheckResult
        niftyConfigureElasticLoadBalancerHealthCheck(
            NiftyConfigureElasticLoadBalancerHealthCheckRequest request);

    /**
     * マルチロードバランサーを作成します。
     *
     * @param request
     *            NiftyCreateElasticLoadBalancerリクエスト
     * @return NiftyCreateElasticLoadBalancer処理結果
     */
    public NiftyCreateElasticLoadBalancerResult
        niftyCreateElasticLoadBalancer(
            NiftyCreateElasticLoadBalancerRequest request);

    /**
     * 指定したマルチロードバランサーのポートを削除します。
     *
     * @param request
     *            NiftyDeleteElasticLoadBalancerリクエスト
     * @return NiftyDeleteElasticLoadBalancer処理結果
     */
    public NiftyDeleteElasticLoadBalancerResult
        niftyDeleteElasticLoadBalancer(NiftyDeleteElasticLoadBalancerRequest request);

    /**
     * 指定したマルチロードバランサーから、指定したサーバーを解除します。
     *
     * @param request
     *            NiftyDeregisterInstancesFromElasticLoadBalancerリクエスト
     * @return NiftyDeregisterInstancesFromElasticLoadBalancer処理結果
     */
    public NiftyDeregisterInstancesFromElasticLoadBalancerResult
        niftyDeregisterInstancesFromElasticLoadBalancer(
            NiftyDeregisterInstancesFromElasticLoadBalancerRequest request);

    /**
     * 指定したマルチロードバランサーに設定されている、サーバーのヘルスチェック結果を取得します。
     *
     * @param request
     *            NiftyDescribeInstanceElasticLoadBalancerHealthリクエスト
     * @return NiftyDescribeInstanceElasticLoadBalancerHealth処理結果
     */
    public NiftyDescribeInstanceElasticLoadBalancerHealthResult
        niftyDescribeInstanceElasticLoadBalancerHealth(
            NiftyDescribeInstanceElasticLoadBalancerHealthRequest request);

    /**
     * 指定したマルチロードバランサーの情報を取得します。
     *
     * @param request
     *            NiftyDescribeElasticLoadBalancersリクエスト
     * @return NiftyDescribeElasticLoadBalancers処理結果
     */
    public NiftyDescribeElasticLoadBalancersResult
        niftyDescribeElasticLoadBalancers(
            NiftyDescribeElasticLoadBalancersRequest request);

    /**
     * 指定したマルチロードバランサーの詳細情報を更新します。
     *
     * @param request
     *            NiftyModifyElasticLoadBalancerAttributesリクエスト
     * @return NiftyModifyElasticLoadBalancerAttributes処理結果
     */
    public NiftyModifyElasticLoadBalancerAttributesResult
        niftyModifyElasticLoadBalancerAttributes(
            NiftyModifyElasticLoadBalancerAttributesRequest request);

    /**
     * 指定したマルチロードバランサーにサーバーを追加します。
     *
     * @param request
     *            NiftyRegisterInstancesWithElasticLoadBalancerリクエスト
     * @return NiftyRegisterInstancesWithElasticLoadBalancer処理結果
     */
    public NiftyRegisterInstancesWithElasticLoadBalancerResult
        niftyRegisterInstancesWithElasticLoadBalancer(
            NiftyRegisterInstancesWithElasticLoadBalancerRequest request);

    /**
     * 指定したマルチロードバランサーにポートを追加します。
     *
     * @param request
     *            NiftyRegisterPortWithElasticLoadBalancerリクエスト
     * @return NiftyRegisterPortWithElasticLoadBalancer処理結果
     */
    public NiftyRegisterPortWithElasticLoadBalancerResult
        niftyRegisterPortWithElasticLoadBalancer(
            NiftyRegisterPortWithElasticLoadBalancerRequest request);

    /**
     * 指定したマルチロードバランサーの設定を変更します。
     *
     * @param request
     *            NiftyUpdateElasticLoadBalancerリクエスト
     * @return NiftyUpdateElasticLoadBalancer処理結果
     */
    public NiftyUpdateElasticLoadBalancerResult
        niftyUpdateElasticLoadBalancer(
            NiftyUpdateElasticLoadBalancerRequest request);

    /**
     * 指定したマルチロードバランサーを最新バージョンに入れ替えます。
     *
     * @param request
     *            NiftyReplaceElasticLoadBalancerLatestVersionリクエスト
     * @return NiftyReplaceElasticLoadBalancerLatestVersion処理結果
     */
    public NiftyReplaceElasticLoadBalancerLatestVersionResult
        niftyReplaceElasticLoadBalancerLatestVersion(
            NiftyReplaceElasticLoadBalancerLatestVersionRequest request);

    /**
     * 指定したマルチロードバランサーに対してSSL証明書を入れ替えます。
     *
     * @param request
     *            NiftyReplaceElasticLoadBalancerListenerSSLCertificateリクエスト
     * @return NiftyReplaceElasticLoadBalancerListenerSSLCertificate処理結果
     */
    public NiftyReplaceElasticLoadBalancerListenerSSLCertificateResult
        niftyReplaceElasticLoadBalancerListenerSSLCertificate(
            NiftyReplaceElasticLoadBalancerListenerSSLCertificateRequest request);

}
