/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.loadbalancer.model.transform;

import com.nifty.cloud.sdk.loadbalancer.model.Sslpolicy;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

/**
 * SSLpolicy変換クラス。<br />
 * このクラスはレスポンスXMLのSSLpolicy要素からSslpolicyクラスを生成します。
 */
public class SslpolicyConverter implements Converter {

    private static final String ELEMENT_SSL_POLICY_ID = "SSLPolicyId";
    private static final String ELEMENT_SSL_POLICY_NAME = "SSLPolicyName";

    /**
     * 変換可能なクラスか判定します。
     * 
     * @param clazz
     *            クラス
     * @return 変換可能な場合true, 変換不可能な場合false
     * 
     * @see com.thoughtworks.xstream.converters.Converter#canConvert(Class)
     */
    @SuppressWarnings("rawtypes")
    @Override
    public boolean canConvert(Class clazz) {
        return clazz == Sslpolicy.class;
    }

    /**
     * SSLpolicyをSslpolicyクラスに変換します。
     * 
     * @param reader
     *            XML読込リーダ
     * @param context
     * @return Sslpolicyオブジェクト
     * 
     * @see com.thoughtworks.xstream.converters.Converter#unmarshal(HierarchicalStreamReader,
     *      UnmarshallingContext)
     */
    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {

        Sslpolicy sslpolicy = new Sslpolicy();
        String name = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();

            name = reader.getNodeName();
            if (name.equals(ELEMENT_SSL_POLICY_ID)) {
                sslpolicy.setSslPolicyId(reader.getValue());
            } else if (name.equals(ELEMENT_SSL_POLICY_NAME)) {
                sslpolicy.setSslPolicyName(reader.getValue());
            }

            reader.moveUp();
        }

        return sslpolicy;
    }

    @Override
    public void marshal(Object paramObject,
        HierarchicalStreamWriter paramHierarchicalStreamWriter,
        MarshallingContext paramMarshallingContext) {
        // 処理無し
    }

}
