/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.loadbalancer.model.transform;

import java.util.ArrayList;
import java.util.List;

import com.nifty.cloud.sdk.loadbalancer.model.SSLPoliciesDescription;
import com.nifty.cloud.sdk.loadbalancer.model.SSLPolicySet;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

/**
 * SSLPoliciesDescriptions変換クラス。<br />
 * このクラスはレスポンスXMLのSSLPoliciesDescriptionsの要素からSSLPoliciesDescriptionクラスを生成します。
 */
public class SSLPoliciesDescriptionsConverter implements Converter {

    private static final String ELEMENT_MEMBER = "member";
    private static final String ELEMENT_SSL_POLICY_ID = "SSLPolicyId";
    private static final String ELEMENT_SSL_POLICY_NAME = "SSLPolicyName";
    private static final String ELEMENT_SSL_POLICY_SET = "SSLPolicySet";

    /**
     * 変換可能なクラスか判定します。
     *
     * @param clazz
     *            クラス
     * @return 変換可能な場合true, 変換不可能な場合false
     *
     * @see com.thoughtworks.xstream.converters.Converter#canConvert(Class)
     */
    @SuppressWarnings("rawtypes")
    @Override
    public boolean canConvert(Class clazz) {
        Class[] interfaces = clazz.getInterfaces();
        for (Class i : interfaces) {
            if (i == List.class) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer,
        MarshallingContext context) {
        // 処理無し
    }

    @SuppressWarnings("unchecked")
    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {

        List<SSLPoliciesDescription> list = new ArrayList<SSLPoliciesDescription>();

        SSLPoliciesDescription set = null;

        SSLPolicySetConverter sslPolicySetConverter = new SSLPolicySetConverter();

        String name = null;

        while (reader.hasMoreChildren()) {

            set = new SSLPoliciesDescription();

            reader.moveDown();

            while (reader.hasMoreChildren()) {

                name = reader.getNodeName();

                if (name.equals(ELEMENT_MEMBER)) {

                    reader.moveDown();

                    name = reader.getNodeName();

                    if (name.equals(ELEMENT_SSL_POLICY_ID)) {
                        set.setSslPolicyId(Integer.parseInt(reader.getValue()));
                    } else if (name.equals(ELEMENT_SSL_POLICY_NAME)) {
                        set.setSslPolicyName(reader.getValue());
                    } else if (name.equals(ELEMENT_SSL_POLICY_SET)) {
                        set.setSslPolicySet(
                            (List<SSLPolicySet>) sslPolicySetConverter.unmarshal(reader, context));
                    }

                }

                reader.moveUp();

            }

            reader.moveUp();

            list.add(set);

        }

        return list;

    }

}
