/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.loadbalancer.model.transform;

import com.nifty.cloud.sdk.Response;
import com.nifty.cloud.sdk.ResponseMetadata;
import com.nifty.cloud.sdk.Result;
import com.nifty.cloud.sdk.loadbalancer.model.NiftySetLoadBalancerSSLPoliciesOfListenerResult;
import com.thoughtworks.xstream.annotations.XStreamAlias;

/**
 * NiftySetLoadBalancerSSLPoliciesOfListenerResponseクラス。<br />
 * このクラスはNiftySetLoadBalancerSSLPoliciesOfListenerのレスポンスを格納します。
 */
@XStreamAlias("NiftySetLoadBalancerSSLPoliciesOfListenerResponse")
public class NiftySetLoadBalancerSSLPoliciesOfListenerResponse implements Response {

    /** NiftySetLoadBalancerSSLPoliciesOfListener処理結果 */
    @XStreamAlias("NiftySetLoadBalancerSSLPoliciesOfListenerResult")
    private NiftySetLoadBalancerSSLPoliciesOfListenerResult niftySetLoadBalancerSSLPoliciesOfListenerResult;

    /** リクエスト情報 */
    @XStreamAlias("ResponseMetadata")
    ResponseMetadata responseMetadata;

    /**
     * NiftySetLoadBalancerSSLPoliciesOfListener処理結果を取得します。
     *
     * @return NiftySetLoadBalancerSSLPoliciesOfListener処理結果
     */

    public NiftySetLoadBalancerSSLPoliciesOfListenerResult
        getNiftySetLoadBalancerSSLPoliciesOfListenerResult() {
        return niftySetLoadBalancerSSLPoliciesOfListenerResult;
    }

    /**
     * NiftySetLoadBalancerSSLPoliciesOfListener処理結果を設定します。
     *
     * @param niftySetLoadBalancerSSLPoliciesOfListenerResult
     *            処理結果
     */
    public void setNiftySetLoadBalancerSSLPoliciesOfListenerResult(
        NiftySetLoadBalancerSSLPoliciesOfListenerResult niftySetLoadBalancerSSLPoliciesOfListenerResult) {
        this.niftySetLoadBalancerSSLPoliciesOfListenerResult =
            niftySetLoadBalancerSSLPoliciesOfListenerResult;
    }

    /**
     * NiftySetLoadBalancerSSLPoliciesOfListenerResponseのResultクラスを取得します。
     * 
     * @see com.nifty.cloud.sdk.Response#getResult()
     */
    @Override
    public Result getResult() {
        return niftySetLoadBalancerSSLPoliciesOfListenerResult;
    }

}
